#include <windows.h>
#include <ddraw.h>
#include "Resource.h"
#include "Global.h"
#include "DirectDraw.h"
#include "Bmp.h"
#include "Font.h"
#include "Timer.h"
#include "Logo.h"
#include "Surface.h"
#include "Cursor.h"

#define SCREEN_WIDTH	800
#define SCREEN_HEIGHT	600
#define SCREEN_BPP		16

CDisplay*		g_pDisplay = NULL;
CFont*			g_pFont	   = NULL;
CTimer*			g_pTimer   = NULL;
CSurface*		g_pSurfaceLogo1 = NULL;
CLogo*			g_pLogo			= NULL;
CCursor*		g_pCursor		= NULL;

BOOL			g_bActive  = FALSE;

RECT g_destRect;
RECT g_srcRect;

BOOL	g_bKeyBuffer[256];

LRESULT CALLBACK MainWndProc ( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
HRESULT WinInit( HINSTANCE hInst, int nCmdShow, HWND* phWnd, HACCEL *phAccel);
HRESULT InitObjects( HWND hWnd);
VOID	DestroyObjects();
HRESULT UpdateFrame();

int APIENTRY WinMain ( HINSTANCE hInst, HINSTANCE hPrevInst, LPSTR pCmdLine, int nCmdShow)
{
	MSG		msg;
	HWND	hWnd;
	HACCEL	hAccel;

	WinInit( hInst, nCmdShow, &hWnd, &hAccel);

	InitObjects( hWnd);
		
	while( TRUE )
	{
		if( PeekMessage ( &msg, NULL, 0, 0, PM_NOREMOVE) )
		{			
			if( 0 == GetMessage( &msg, NULL, 0, 0))
			{
				return (int) msg.wParam;
			}

			if( 0 == TranslateAccelerator( hWnd, hAccel, &msg))
			{
				TranslateMessage( &msg);
				DispatchMessage ( &msg);
			}
		}
		else
		{
			if( g_bActive)
			{
				UpdateFrame();
			}
			else
			{
				WaitMessage();
			}

		}
	}
}

HRESULT WinInit( HINSTANCE hInst, int nCmdShow, HWND* phWnd, HACCEL *phAccel)
{
	WNDCLASS	wc;
	HWND		hWnd;
	HACCEL		hAccel;

	wc.lpszClassName = TEXT("DIABLO");
	wc.lpfnWndProc   = MainWndProc;
	wc.style		 = CS_VREDRAW|CS_HREDRAW;
	wc.hInstance	 = hInst;
	wc.hIcon		 = LoadIcon(hInst, MAKEINTRESOURCE(IDI_MAIN));
	wc.hCursor		 = LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground = (HBRUSH) (COLOR_WINDOW+1);
	wc.lpszMenuName  = NULL;
	wc.cbClsExtra	 = 0;
	wc.cbWndExtra    = 0;

	if( RegisterClass ( &wc) == 0)
		return E_FAIL;

	hAccel = LoadAccelerators ( hInst, MAKEINTRESOURCE(IDR_MAIN_ACCEL) );

	hWnd   = CreateWindowEx ( 0, TEXT("DIABLO"), TEXT("Diablo MainWin Program"),
							WS_POPUP, 0, 0, SCREEN_WIDTH, SCREEN_HEIGHT, NULL, NULL, hInst, NULL);

	if( hWnd == NULL) return E_FAIL;

	ShowWindow( hWnd, nCmdShow);
	UpdateWindow( hWnd);

	*phWnd = hWnd;
	*phAccel = hAccel;

	return S_OK;
}

LRESULT CALLBACK MainWndProc ( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{

	if(g_pCursor!=NULL) g_pCursor->Proc( msg, wParam, lParam);

	switch ( msg)
	{
		case WM_SIZE:
			g_bActive = TRUE;
			break;

		case WM_COMMAND:
			switch ( LOWORD( wParam))
			{
				case IDM_EXIT:
					PostMessage( hWnd, WM_CLOSE, 0, 0);
					return 0L;
			}
			break;


		case WM_KEYDOWN:
			g_bKeyBuffer[wParam] = true;

			if(g_pLogo!= NULL) g_pLogo->GetKeyBuffer(wParam);
			break;

		case WM_KEYUP:
			g_bKeyBuffer[wParam] = false;
			break;
			

		case WM_SYSCOMMAND:
			switch (wParam)
			{
				case SC_MOVE:			
				case SC_SIZE:
				case SC_MAXIMIZE:
				case SC_MONITORPOWER:
					return TRUE;
			}
			break;

		case WM_DESTROY:
			DestroyObjects();
			PostQuitMessage(0);
			return 0L;
	}

	return DefWindowProc(hWnd, msg, wParam, lParam);
}

HRESULT InitObjects(HWND hWnd)
{

	ShowCursor(FALSE);

	g_pDisplay = new CDisplay();
	
	if( g_pDisplay->IsWindowed())
		g_pDisplay->CreateWindowedDisplay(hWnd,SCREEN_WIDTH, SCREEN_HEIGHT);
	else	
		g_pDisplay->CreateFullScreenDisplay( hWnd, SCREEN_WIDTH, SCREEN_HEIGHT, SCREEN_BPP);
	
	g_pDisplay->Clear(0);					// BackSurface			: Clear

	g_pFont = new CFont();
	g_pFont->CreateFonts();

	g_pTimer = new CTimer();
	g_pTimer->InitTimer();
	g_pTimer->InitMainTimer();

	g_pCursor = new CCursor();
	g_pCursor->Create( g_pDisplay, 35, 30);
	
	// ------------------------------------------------
	g_pLogo = new CLogo();
	g_pLogo->InitLogo();
	
	g_pSurfaceLogo1 = new CSurface();
	g_pSurfaceLogo1->Create(g_pDisplay->GetDirectDraw(), 800, 600);
	//---------------------------------------------------


	return S_OK;

}

VOID DestroyObjects()
{
	//----------------------------------------------------
	SAFE_DELETE( g_pSurfaceLogo1);
	SAFE_DELETE( g_pLogo);
	//----------------------------------------------------

	SAFE_DELETE( g_pTimer);
	SAFE_DELETE( g_pFont);
	SAFE_DELETE( g_pDisplay );

	ShowCursor(TRUE);

}

HRESULT UpdateFrame()
{

	// Update Timer (Display is Not to do , Just Timer Update)
	g_pTimer->UpdateTimer();
	g_pTimer->UpdateMainTimer();
	
	////////////////////////////////////////////////////////////////////////////////////////
	// Logo Logic
	if(g_pLogo->GetCount() == 0 )	// Just first time
	{
		
		g_pSurfaceLogo1->LoadBmp("Logo1.bmp");	// Test Surface Bitmap	: Loading
		g_pLogo->m_nCount = 1;		// Logo Logic Count = 1 Next
	}

	if( (g_pLogo->GetCount() == 2) )
	{
		g_pSurfaceLogo1->LoadBmp("Logo2.bmp");
		g_pLogo->m_nCount = 3;
	}

	if( (g_pLogo->GetCount() == 4) )
	{
		g_pSurfaceLogo1->LoadBmp("StartMenu.bmp");
		g_pLogo->m_nCount = 5;
		g_pCursor->SetShow(400, 250, true);
	}

	// Logo1 Suface (Image)
	g_destRect.left	= 0;	g_destRect.top	= 0;	g_destRect.right= 800;		g_destRect.bottom	= 600;
	g_srcRect.left	= 0;	g_srcRect.top	= 0;	g_srcRect.right	= 800;		g_srcRect.bottom	= 600;
	g_pDisplay->GetBackBuffer()->Blt(&g_destRect, g_pSurfaceLogo1->GetDDrawSurface(), &g_srcRect,DDBLT_WAIT, NULL);

	g_srcRect.left	= 0;	g_srcRect.top	= 0;	g_srcRect.right	= 35;		g_srcRect.bottom	= 30;
	if( g_pCursor->GetShow()) g_pDisplay->GetBackBuffer()->BltFast( g_pCursor->m_point.x, g_pCursor->m_point.y, g_pCursor->m_pSurface->GetDDrawSurface(),&g_srcRect, DDBLTFAST_WAIT|DDBLTFAST_SRCCOLORKEY);
	////////////////////////////////////////////////////////////////////////////////////////

	//-----------------------------
	// Timer Display
	g_pDisplay->OutText( NORMAL, 600, 10, g_pTimer->m_string,RGB(255,0,0),NULL);
	
	// Logo Counter Display
	char string[20];
	sprintf(string,"Logo Counter : %d",g_pLogo->GetCount());
	g_pDisplay->OutText( NORMAL, 600, 30, string, RGB(255,0,0), NULL);
	//-----------------------------
	sprintf(string,"Main Timer : %d", g_pTimer->GetMainTime());
	g_pDisplay->OutText( NORMAL, 600, 50, string, RGB(255,0,0), NULL);

	// Flip
	g_pDisplay->Present();

	return S_OK;
}
