//////////////////////////////////////////////////////////////////////////////////
// $Source: /cvsroot/cdx/cdx3.0/addons/CDXBitmapMenu/cdxbitmap.h,v $
// $Author: hebertjo $
//
// $Log: cdxbitmap.h,v $
// Revision 1.1.1.1  2000/04/22 16:50:40  hebertjo
// Initial checkin of v3.0 to SourceForge CVS.
//
// Revision 1.1.1.1  1999/05/04 23:59:24  bsimser
// Imported addons
//
// $Revision: 1.1.1.1 $
//////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////
// CTimer class implementation
///////////////////////////////////////////////////////////////////
class CDXTimer
{
public:
    CDXTimer() : m_dwTimer(0) {};
    int	    Kill();  //kills a timer using ID
    void    Reset(); //resets a timer to current time using ID
    int		LockTime(); //set a timer if the m_dwTimer is 0.
    DWORD   Get( BYTE a_btReset=1 );  //returns a timers difference in time of timer ID
    int     IsInTime( UINT, BYTE a_btReset=1 );

private:
    DWORD      m_dwTimer;  
};


//////////////////////////////////////////////////////////////////////////////////
// CDXToolTip Class
//////////////////////////////////////////////////////////////////////////////////
class CDXToolTip
{
public:
    CDXToolTip(CDXBitmapFont *font, const char *string, COLORREF fillcol=0, COLORREF bordercol=0, int bordersize=0);
    virtual ~CDXToolTip();

    BOOL Draw(CDXSurface *lpDDS, int x, int y);
    BOOL IsEnabled()        { return m_IsEnabled; }

private:
    CDXBitmapFont  *m_pFont;            // bitmap font pointer
    char            m_cString[80];      // 80 chars max in string
    int             m_iYOffset;         // unused
    int             m_iXOffset;         // unused
    COLORREF        m_FillColor;        // RGB color of fill
    COLORREF        m_BorderColor;      // RGB color of border
    int             m_iBorder;          // width in pixels of border
    BOOL            m_IsEnabled;        // enabled flag
};


// button states as bit settings
#define     LMB_DOWN    0x0001      // left mouse button is down
#define     LMB_DEDGE   0x0002      // left mouse button just went down
#define     LMB_UEDGE   0x0004      // left mouse button just came up ( unused )
#define     LMB_DCLICK	0x0008      // left mouse button double clicked

// middle mouse button
#define     MMB_DOWN    0x0010
#define     MMB_DEDGE   0x0020
#define     MMB_UEDGE   0x0040
#define     MMB_DCLICK  0x0080

// right mouse button
#define     RMB_DOWN    0x0100      
#define     RMB_DEDGE   0x0200
#define     RMB_UEDGE   0x0400
#define     RMB_DCLICK	0x0800

#define		BUTTON_FLAG			0
#define		BUTTON_DOWN			1
#define		BUTTON_UP			2

class CDXMenu;
class CDXMenuButton;

typedef HRESULT (CDXMenuButton::* MOUSEMOVE)(POINT, int);
typedef int (*MOUSECALLBACK)(POINT, int);

//////////////////////////////////////////////////////////////////////////////////
// CDXMenuButton Class
//////////////////////////////////////////////////////////////////////////////////
class CDXMenuButton
{
public:
	CDXMenuButton();
	virtual ~CDXMenuButton();

	void		ButtonItem(CDXMenu*);
	HRESULT		MouseMove(POINT, int);
    void        SetButton(UINT, POINT);
    void        SetButtonID(UINT);			// The button ID must be greater than 0

    CDXToolTip  *m_pToolTipCtrl;
    CDXToolTip  *GetToolTipCtrl()       { return m_pToolTipCtrl; }

    void        RegisterMouseEnter(MOUSECALLBACK);
    void        RegisterMouseLeave(MOUSECALLBACK);
    
 	virtual POINT   GetPtInButton()=0;
	virtual int     IsInButton(POINT)=0;
    virtual void    SetButtonPos(POINT)=0;
	virtual HRESULT DrawButton(CDXSurface*)=0;

    static	UINT	m_DownButtonID;
	static	void	ResetButton();
 	static	POINT   GetPtInButton(RECT*);
    
    friend  class   CDXMenu;

private:
	UINT			m_ButtonID;
    
	HRESULT			ButtonMenuMouseMove(POINT, int);
	HRESULT			SubMenuMouseMove(POINT, int);

 	HRESULT			GetButtonState(int);
	MOUSEMOVE		m_pFNMouseMove;

    MOUSECALLBACK   m_pFNMouseEnter;
    MOUSECALLBACK   m_pFNMouseLeave;


protected:
    CDXTimer        m_ButtonTimer;
    int				m_DrawState;
	CDXMenu*		m_pSubMenu;


	void	DrawToolTip(CDXSurface*, RECT*);
};

//////////////////////////////////////////////////////////////////////////////////
// CDXBitmapButton Class
//////////////////////////////////////////////////////////////////////////////////
class CDXBitmapButton : virtual public CDXSprite,
                        virtual public CDXMenuButton
{
public:
	CDXBitmapButton();
	CDXBitmapButton(CDXScreen* pScreen, const char* szFilename, int w, int h, int num, BOOL memoryType);
	virtual ~CDXBitmapButton();


 	virtual POINT   GetPtInButton();
	virtual int     IsInButton(POINT);
    virtual void    SetButtonPos(POINT);
	virtual HRESULT DrawButton(CDXSurface*);


private:
protected:
};

#define     TEXT_COLOR      3

//////////////////////////////////////////////////////////////////////////////////
// CDXTextButton Class
//////////////////////////////////////////////////////////////////////////////////
class CDXTextButton : virtual public CDXMenuButton
{
public:
	CDXTextButton();
	CDXTextButton(CDXScreen* pScreen, const char* szString, COLORREF, COLORREF, COLORREF);
	virtual ~CDXTextButton();


 	virtual POINT   GetPtInButton();
	virtual int     IsInButton(POINT);
    virtual void    SetButtonPos(POINT);
	virtual HRESULT DrawButton(CDXSurface*);

    void    SetString(const char*);
    void    ChangeFont(const char*, int, int, int =FW_NORMAL);

private:
    CDXSurface*     m_pSurface;
    int             m_iString;
    char*           m_pszString;
    COLORREF        m_TextClr[TEXT_COLOR];


protected:
};

#define     BITMAP_FONT      3

//////////////////////////////////////////////////////////////////////////////////
// CDXBmpTextButton Class
//////////////////////////////////////////////////////////////////////////////////
class CDXBmpTextButton : virtual public CDXMenuButton
{
public:
	CDXBmpTextButton();
	CDXBmpTextButton(const char* szString, CDXBitmapFont*, CDXBitmapFont*, CDXBitmapFont*);
	virtual ~CDXBmpTextButton();


 	virtual POINT   GetPtInButton();
	virtual int     IsInButton(POINT);
    virtual void    SetButtonPos(POINT);
	virtual HRESULT DrawButton(CDXSurface*);

    void    AddBitmapFont(CDXBitmapFont*, CDXBitmapFont*, CDXBitmapFont*);
    void    SetString(const char*);


private:
    int             m_iString;
    char*           m_pszString;
    POINT           m_Pos;
    CDXBitmapFont*  m_BmpFont[BITMAP_FONT];


protected:
};

#define     KEY_UP                  1
#define     KEY_DOWN                2
#define     KEY_HOME                3
#define     KEY_END                 4
#define     KEY_GO_SUB              5
#define     KEY_LEAVE_SUB           6
#define     KEY_ENTER               7

#define     MAX_MENU_ITEMS		20
#define     MAX_STRING_LENGTH	80

typedef struct  BITMAPBUTTONINFO
{
    char*   szFileName;
    int     w;
    int     h;
    int     num;
    BOOL    memoryType;
    POINT   pos;
    UINT    buttonID;		// it must be greater than 0
} BitmapButtonInfo;

typedef struct  TEXTBUTTONINFO
{
    char*           szString;
    COLORREF        flagClr;
    COLORREF        downClr;
    COLORREF        upClr;
    POINT           pos;
    UINT            buttonID;		// it must be greater than 0
} TextButtonInfo;

typedef struct  BMPTEXTBUTTONINFO
{
    char*           szString;
    CDXBitmapFont*  bmpFontFlag;
    CDXBitmapFont*  bmpFontDown;
    CDXBitmapFont*  bmpFontUp;
    POINT           pos;
    UINT            buttonID;		// it must be greater than 0
} BmpTextButtonInfo;

//////////////////////////////////////////////////////////////////////////////////
// CDXMenu Class
//////////////////////////////////////////////////////////////////////////////////
class CDXMenu : virtual public CDXSurface
{
public:
	CDXMenu();
	CDXMenu(CDXScreen *pScreen, int Width, int Height, BOOL memoryType);
	CDXMenu(CDXScreen *pScreen, const char *szFilename, BOOL memoryType);

	virtual ~CDXMenu();

	CDXMenuButton*		m_pMenuButton[MAX_MENU_ITEMS];

	void	    AddItem(CDXScreen*, BitmapButtonInfo*, CDXBitmapButton**);
	void	    AddItem(CDXScreen*, TextButtonInfo*, CDXTextButton**);
	void	    AddItem(BmpTextButtonInfo*, CDXBmpTextButton**);
	int		    IsInMenu(POINT);


	// It handles the key down message
	HRESULT 	UpMenu(POINT* =NULL);
	HRESULT 	DownMenu(POINT* =NULL);
	HRESULT 	HomeMenu(POINT* =NULL);
    HRESULT     EndMenu(POINT* =NULL);
    HRESULT     EnterMenu(POINT* =NULL);
    HRESULT     GoSubMenu(POINT* =NULL);
    HRESULT     LeaveSubMenu(POINT* =NULL);
	void    	IsWrap(int);

    void        RegisterMouse(POINT*);

	virtual HRESULT DrawMenu(CDXSurface* lpDDS);
	virtual HRESULT MouseMove(int, POINT* =NULL);


	static POINT	LockMouse;
	static int		ButtonState;


private:
    CDXTimer        m_MenuTimer;
	CDXMenu*		m_pSubMenu;

    POINT*          m_pMouse;
	int 			m_CurButtonID;
	int 			m_CurKey;
	int				m_ItemCount;
	int				m_Wrap;

	void			Constructor();
	int 			GetNextMenuButtonID(int =1);
	int 			IsKeyActivate(int, POINT*);
	HRESULT 		KeyMessage(int, POINT*, int);
	void	        AddItem(CDXMenuButton*, POINT, UINT);


protected:
};
