//////////////////////////////////////////////////////////////////////////////////
// $Source: /cvsroot/cdx/cdx3.0/addons/CDXBitmapMenu/cdxbitmapbutton.cpp,v $
// $Author: hebertjo $
//
// $Log: cdxbitmapbutton.cpp,v $
// Revision 1.1.1.1  2000/04/22 16:50:57  hebertjo
// Initial checkin of v3.0 to SourceForge CVS.
//
// Revision 1.1.1.1  1999/05/04 23:59:24  bsimser
// Imported addons
//
// $Revision: 1.1.1.1 $
//////////////////////////////////////////////////////////////////////////////////

#include "CDX.h"
#include "cdxbitmap.h"

CDXBitmapButton::CDXBitmapButton() : CDXSprite(), CDXMenuButton()
{
}


CDXBitmapButton::CDXBitmapButton(CDXScreen *pScreen, const char* szFilename, int w, int h, int num, BOOL memoryType) :
    			 CDXSprite(pScreen, szFilename, w, h, num, memoryType), CDXMenuButton()
{
}


CDXBitmapButton::~CDXBitmapButton()
{
}


//
//	Purpose:	Get the point which is inside the button
//
/////////////////////////////////////////////////////////////////
POINT CDXBitmapButton::GetPtInButton()
{
    return CDXMenuButton::GetPtInButton(&m_Tile->DestRect);
}


//
//	Purpose:	Check if the pt is in button.
//
/////////////////////////////////////////////////////////////////
int	CDXBitmapButton::IsInButton(POINT pt)
{
	return PtInRect(&m_Tile->DestRect, pt);
}


//
//	Purpose:	Set the button position where is the left right
//				corner we are going to draw
//
/////////////////////////////////////////////////////////////////
void CDXBitmapButton::SetButtonPos(POINT pt)
{
	m_Tile->SetDest(pt.y, pt.x, pt.y+m_Tile->m_BlockHeight, pt.x+m_Tile->m_BlockWidth);
}


//
//	Purpose:	Draw the proper image to screen.
//
////////////////////////////////////////////////////////////
HRESULT CDXBitmapButton::DrawButton(CDXSurface* lpDDS)
{
	SetFrame(m_DrawState);	//set CDXSprite frame
	SetPos(m_Tile->DestRect.left,m_Tile->DestRect.top);	//set CDXSprite position
	Draw(lpDDS,0,0,CDXBLT_TRANS);	//call CDXSprite draw

	// Draw tool tip
    DrawToolTip(lpDDS, &m_Tile->DestRect);
	return 1;
}

