//////////////////////////////////////////////////////////////////////////////////
// $Source: /cvsroot/cdx/cdx3.0/addons/CDXBitmapMenu/cdxbmptextbutton.cpp,v $
// $Author: hebertjo $
//
// $Log: cdxbmptextbutton.cpp,v $
// Revision 1.1.1.1  2000/04/22 16:50:59  hebertjo
// Initial checkin of v3.0 to SourceForge CVS.
//
// Revision 1.1.1.1  1999/05/04 23:59:24  bsimser
// Imported addons
//
// $Revision: 1.1.1.1 $
//////////////////////////////////////////////////////////////////////////////////

#include "CDX.h"
#include "cdxbitmap.h"

#include <stdio.h>
#include <string.h>


CDXBmpTextButton::CDXBmpTextButton() : CDXMenuButton()
{
	//	Initialize
    m_iString = 0;
    m_pszString = NULL;
    for(int i=0; i<TEXT_COLOR; i++)
    {
        m_BmpFont[i] = NULL;
    }
}


CDXBmpTextButton::CDXBmpTextButton(const char* szString, CDXBitmapFont* pBmpFontFlag, CDXBitmapFont* pBmpFontDown, CDXBitmapFont* pBmpFontUp) :
                  CDXMenuButton()
{
	//	Initialize and create a m_pSurface and set m_iString and m_TextClr
    m_iString = strlen(szString);
    m_pszString = new char(m_iString+1);
    sprintf(m_pszString, "%s", szString);

    m_BmpFont[BUTTON_FLAG] = pBmpFontFlag;
    m_BmpFont[BUTTON_DOWN] = pBmpFontDown;
    m_BmpFont[BUTTON_UP] = pBmpFontUp;
}


CDXBmpTextButton::~CDXBmpTextButton()
{
    if (m_pszString)
    {
        delete [] m_pszString;
    }
}


void CDXBmpTextButton::AddBitmapFont(CDXBitmapFont* pBmpFontFlag, CDXBitmapFont* pBmpFontDown, CDXBitmapFont* pBmpFontUp)
{
    m_BmpFont[BUTTON_FLAG] = pBmpFontFlag;
    m_BmpFont[BUTTON_DOWN] = pBmpFontDown;
    m_BmpFont[BUTTON_UP] = pBmpFontUp;

    SetButtonPos(m_Pos);
}


//
//	Purpose:	Get the point which is inside the button
//
/////////////////////////////////////////////////////////////////
POINT CDXBmpTextButton::GetPtInButton()
{
	if (!m_BmpFont[BUTTON_FLAG])
	{
        POINT pt={-1,-1};
		return pt;
	}

    return CDXMenuButton::GetPtInButton(&m_BmpFont[BUTTON_FLAG]->DestRect);
}


//
//	Purpose:	Check if the pt is in button.
//
/////////////////////////////////////////////////////////////////
int	CDXBmpTextButton::IsInButton(POINT pt)
{
    if (!m_BmpFont[BUTTON_FLAG])
	{
        return 0;
	}
	return PtInRect(&m_BmpFont[BUTTON_FLAG]->DestRect, pt);
}


//
//	Purpose:	Set the button position where is the left right
//				corner we are going to draw
//
/////////////////////////////////////////////////////////////////
void CDXBmpTextButton::SetButtonPos(POINT pt)
{
    for(int i=0; i<BITMAP_FONT; i++)
    {
        if (m_BmpFont[i])
        {
            m_BmpFont[i]->DestRect.left = m_BmpFont[i]->DestRect.right = pt.x;
		    m_BmpFont[i]->DestRect.bottom = m_BmpFont[i]->DestRect.top = pt.y;

        } else {
            m_Pos = pt;
            return;

        }
    }
}


void CDXBmpTextButton::SetString(const char* szString)
{
    if (!szString)
    {
        return;
    }
    delete [] m_pszString;
    m_iString = strlen(szString);
    m_pszString = new char(m_iString+1);
    sprintf(m_pszString, "%s", szString);
}


//
//	Purpose:	Draw the proper text to screen.
//
////////////////////////////////////////////////////////////
HRESULT CDXBmpTextButton::DrawButton(CDXSurface* lpDDS)
{
    CDXBitmapFont*  pDrawBmpFont=m_BmpFont[m_DrawState];
    if (!pDrawBmpFont)
    {
        return 0;
    }

    int retVal=pDrawBmpFont->Print(lpDDS, m_Pos.x, m_Pos.y, m_pszString);
    SIZE sz=pDrawBmpFont->GetTextExtent(m_pszString);

	// Reset the dest rectangle since print function will change the rectangle
    pDrawBmpFont->SetDest(m_Pos.y, m_Pos.x, m_Pos.y+sz.cy, m_Pos.x+sz.cx);

	// Draw tool tip
    DrawToolTip(lpDDS, &pDrawBmpFont->DestRect);
    return retVal;
}
