//////////////////////////////////////////////////////////////////////////////////
// $Source: /cvsroot/cdx/cdx3.0/addons/CDXBitmapMenu/cdxtextbutton.cpp,v $
// $Author: hebertjo $
//
// $Log: cdxtextbutton.cpp,v $
// Revision 1.1.1.1  2000/04/22 16:51:07  hebertjo
// Initial checkin of v3.0 to SourceForge CVS.
//
// Revision 1.1.1.1  1999/05/04 23:59:24  bsimser
// Imported addons
//
// $Revision: 1.1.1.1 $
//////////////////////////////////////////////////////////////////////////////////

#include "CDX.h"
#include "cdxbitmap.h"

#include <stdio.h>
#include <string.h>

#define     BLACK_CLR           RGB(0,0,0)
#define     SHADOW_OFFSET_X     2
#define     SHADOW_OFFSET_Y     2

CDXTextButton::CDXTextButton() : CDXMenuButton()
{
	//	Initialize
    m_pSurface = NULL;
    m_iString = 0;
    m_pszString = NULL;
    for(int i=0; i<TEXT_COLOR; i++)
    {
        m_TextClr[i] = RGB(255,255,255);
    }
}


CDXTextButton::CDXTextButton(CDXScreen* pScreen, const char* szString, COLORREF flagClr, COLORREF downClr, COLORREF upClr) : 
               CDXMenuButton()
{
	//	Initialize and create a m_pSurface and set m_iString and m_TextClr
    m_pSurface = new CDXSurface();
    m_pSurface->Screen = pScreen;

    m_iString = strlen(szString);
    m_pszString = new char(m_iString+1);
    sprintf(m_pszString, "%s", szString);

    m_TextClr[BUTTON_FLAG] = flagClr;
    m_TextClr[BUTTON_DOWN] = downClr;
    m_TextClr[BUTTON_UP] = upClr;
}


CDXTextButton::~CDXTextButton()
{
    if (m_pSurface)
    {
        delete m_pSurface;
    }
    if (m_pszString)
    {
        delete [] m_pszString;
    }
}


//
//	Purpose:	Get the point which is inside the button
//
/////////////////////////////////////////////////////////////////
POINT CDXTextButton::GetPtInButton()
{
	if (!m_pSurface)
	{
        POINT pt={-1,-1};
		return pt;
	}

    return CDXMenuButton::GetPtInButton(&m_pSurface->DestRect);
}


//
//	Purpose:	Check if the pt is in button.
//
/////////////////////////////////////////////////////////////////
int	CDXTextButton::IsInButton(POINT pt)
{
    if (!m_pSurface)
	{
        return 0;
	}
	return PtInRect(&m_pSurface->DestRect, pt);
}


//
//	Purpose:	Set the button position where is the left right
//				corner we are going to draw
//
/////////////////////////////////////////////////////////////////
void CDXTextButton::SetButtonPos(POINT pt)
{
	if (m_pSurface)
	{
		m_pSurface->DestRect.left = m_pSurface->DestRect.right = pt.x;
		m_pSurface->DestRect.bottom = m_pSurface->DestRect.top = pt.y;
	}
}


//
//	Purpose:	Change font of m_pSurface
//
/////////////////////////////////////////////////////////////////
void CDXTextButton::ChangeFont(const char* FontName, int Width, int Height, int Attributes)
{
    m_pSurface->ChangeFont(FontName, Width, Height, Attributes);
}


void CDXTextButton::SetString(const char* szString)
{
    if (!szString)
    {
        return;
    }
    delete [] m_pszString;
    m_iString = strlen(szString);
    m_pszString = new char(m_iString+1);
    sprintf(m_pszString, "%s", szString);
}


//
//	Purpose:	Draw the proper text to screen.
//
////////////////////////////////////////////////////////////
HRESULT CDXTextButton::DrawButton(CDXSurface* lpDDS)
{
    if ( (!m_pszString) || (!m_pSurface) )
    {
        return 0;
    }

    CDXSurface* pBkSurface=m_pSurface->Screen->GetBack();
	pBkSurface->GetDC();

    // Set Font and Draw text
    m_pSurface->m_DC = pBkSurface->m_DC;
    m_pSurface->SetFont();
    pBkSurface->TextXY(m_pSurface->DestRect.left+SHADOW_OFFSET_X, m_pSurface->DestRect.top+SHADOW_OFFSET_Y, BLACK_CLR, m_pszString);
    pBkSurface->TextXY(m_pSurface->DestRect.left, m_pSurface->DestRect.top, m_TextClr[m_DrawState], m_pszString);

	// Get the size of text
    int     retVal=1;
    SIZE    sz;
    if (!GetTextExtentPoint32(pBkSurface->m_DC, m_pszString, m_iString, &sz))
    {
        retVal = 0;
    }

    // Set the original font
    pBkSurface->SetFont();
	pBkSurface->ReleaseDC();

	// Update the new size
    m_pSurface->DestRect.right = m_pSurface->DestRect.left+sz.cx;
    m_pSurface->DestRect.bottom = m_pSurface->DestRect.top+sz.cy;

	// Draw tool tip
    DrawToolTip(lpDDS, &m_pSurface->DestRect);
    return retVal;
}
