//////////////////////////////////////////////////////////////////////////////////
// $Source: /cvsroot/cdx/cdx3.0/addons/CDXBitmapMenu/cdxtimer.cpp,v $
// $Author: hebertjo $
//
// $Log: cdxtimer.cpp,v $
// Revision 1.1.1.1  2000/04/22 16:51:07  hebertjo
// Initial checkin of v3.0 to SourceForge CVS.
//
// Revision 1.1.1.1  1999/05/04 23:59:24  bsimser
// Imported addons
//
// $Revision: 1.1.1.1 $
//////////////////////////////////////////////////////////////////////////////////

#undef WIN32_LEAN_AND_MEAN
#define WIN32_LEAN_AND_MEAN

#include "CDX.h"
#include "cdxbitmap.h"

///////////////////////////////////////////////////////////////////
//	Set the timer ID's time to 0.  This makes the timer available.
//
//	Return:	>0 when we kill the timer.
//			 0 when it is already killed.
// 
///////////////////////////////////////////////////////////////////
int CDXTimer::Kill()
{
	if (!m_dwTimer)
	{
		return 0;
	}
	m_dwTimer = 0;
	return 1;
}


///////////////////////////////////////////////////////////////////
// Resets the specified timer ID's time to current time.
///////////////////////////////////////////////////////////////////
void CDXTimer::Reset()
{
	m_dwTimer = timeGetTime();
}


///////////////////////////////////////////////////////////////////
// Get the specified timer ID's time difference since last time.
// Resets this timer after difference.
///////////////////////////////////////////////////////////////////
DWORD CDXTimer::Get( BYTE a_btReset )
{
    DWORD dwTimeDiff;

    dwTimeDiff = timeGetTime() - m_dwTimer;
    if (a_btReset)
    {
        m_dwTimer = timeGetTime();
    }

    return( dwTimeDiff );
}


//
//  Return: <0 when m_dwTimer is not initialized
//           0 when it is not in time
//          >0 when it is in time
//
/////////////////////////////////////////////////////////////
int CDXTimer::IsInTime( UINT dwTimeDiff, BYTE a_btReset )
{
    if (!m_dwTimer)
    {
        return -1;
    }

    if ( Get(a_btReset)<dwTimeDiff )
    {
        return  1;
    }
    return 0;
}


//
//  Return: >0 when m_dwTimer is first set
//           0 when m_dwTimer is already set
//
/////////////////////////////////////////////////////////////
int CDXTimer::LockTime()
{
    if (!m_dwTimer)
    {
        return (m_dwTimer=timeGetTime());
    }
    return 0;
}
