//////////////////////////////////////////////////////////////////////////////////
// $Source: /cvsroot/cdx/cdx3.0/addons/CDXBitmapMenu/cdxtooltip.cpp,v $
// $Author: hebertjo $
//
// $Log: cdxtooltip.cpp,v $
// Revision 1.1.1.1  2000/04/22 16:51:10  hebertjo
// Initial checkin of v3.0 to SourceForge CVS.
//
// Revision 1.1.1.1  1999/05/04 23:59:24  bsimser
// Imported addons
//
// $Revision: 1.1.1.1 $
//////////////////////////////////////////////////////////////////////////////////

#include "CDX.h"
#include "cdxbitmap.h"

/*
// put this back in if we want default constructor and implement a Create function
CDXToolTip::CDXToolTip()
{
    m_IsEnabled = FALSE;
    m_pFont = NULL;
    m_cString[0] = '\0';
    m_iYOffset = 0;
    m_iXOffset = 0;
    m_FillColor = 0;
    m_BorderColor = 0;
    m_iBorder = 1;
}
*/


//////////////////////////////////////////////////////////////
//   CDXToolTip Class Constructor
// Function name : CDXToolTip::CDXToolTip
// Description   : Sets associated CDXBitmapFont and string, and color information
//////////////////////////////////////////////////////////////
CDXToolTip::CDXToolTip(CDXBitmapFont *font, const char *string, COLORREF fillcol, COLORREF bordercol, int bordersize)
{
    m_iYOffset = 0;
    m_iXOffset = 0;
    m_pFont = font;
    strncpy(m_cString, string, 79);
    m_FillColor = fillcol;
    m_BorderColor = bordercol;
    m_iBorder = bordersize;
    m_IsEnabled = TRUE;
}


//////////////////////////////////////////////////////////////
//   CDXToolTip Class Destructor
// Function name : CDXToolTip::~CDXToolTip
// Description   : Nothing
//////////////////////////////////////////////////////////////
CDXToolTip::~CDXToolTip()
{
}



//////////////////////////////////////////////////////////////
// Function name : CDXToolTip::Draw
// Description   : Draw associated text at x,y position on specified surface.
//////////////////////////////////////////////////////////////
BOOL CDXToolTip::Draw(CDXSurface *lpDDS, int x, int y)
{
    // if no font, bail
    if(!m_pFont)
        return FALSE;

    //if border, draw fill & border
	if(m_iBorder)
	{
        //get size of string in pixels so we know the size of the box
		SIZE sz = m_pFont->GetTextExtent(m_cString);

        // Having problems with this function call.  
        // Inside the Rect() I get GPF on accessing pixels to Horz line.
		//lpDDS->Rect(x, y, x+sz.cx, y+sz.cy, m_BorderColor);

        // fill using border color 
		lpDDS->FillRect(x-6, y-3, x+6+sz.cx, y+3+sz.cy, m_BorderColor);
        // fill inside using fill color.  the effect is a border around solid background
		lpDDS->FillRect(x-6+m_iBorder,y-3+m_iBorder,x+6-m_iBorder+sz.cx, y+3-m_iBorder+sz.cy, m_FillColor);
	}

    // call the CDXBitmapFont draw string function.
    m_pFont->Print(lpDDS, x, y, m_cString); //print the string using our bitmap font.

    return TRUE;
}
