//////////////////////////////////////////////////////////////////////////////////
// $Source: /cvsroot/cdx/cdx3.0/addons/CDXBitmapMenu/sample.cpp,v $
// $Author: hebertjo $
//
// $Log: sample.cpp,v $
// Revision 1.1.1.1  2000/04/22 16:51:13  hebertjo
// Initial checkin of v3.0 to SourceForge CVS.
//
// Revision 1.1.1.1  1999/05/04 23:59:24  bsimser
// Imported addons
//
// $Revision: 1.1.1.1 $
//////////////////////////////////////////////////////////////////////////////////

//  This is just a sample of how some of the GUI classes are handled.
//  This will not compile into a sample, it just shows how to use
//  the samples for now.
//
//  Any questions or comments can be directed to Perry or Billy.
//
//	Perry Robertson - proberts@cgocable.net
//  Billy Chi Kin Fung - billyf@loha.com

#include "cdx.h"
#include "cdxbitmap.h"

#include "stdlib.h"     // for convert integer to string for testing

#include "CharacterManager.h"

CCharacterManager charManager;
extern  POINT    CursorPos;

enum tagMenuIDs {
    MID_MAINMENU=0,
    MID_CHARSELECTMENU,
};

#define		NUM_OF_MENU			2
static CDXMenu*	Menus[] =	{ NULL, NULL };
static int			menuRect[NUM_OF_MENU*4] =	{	0,0,480,640,
													0,0,480,640,
													};

enum tagMainMenuButtonIDs {
    BID_MAINMENU_NEWGAME=1,
    BID_MAINMENU_CHARSELECT,
    BID_MAINMENU_OPTIONS,
	BID_MAINMENU_CREDITS,
    BID_MAINMENU_EXIT,
};

enum tagCharSelMenuButtonIDs {
    BID_CHARSELMENU_READY=1,
    BID_CHARSELMENU_OK,
    BID_CHARSELMENU_CANCEL,
};


static BitmapButtonInfo buttonMainMenu[] = 
{
    // filename, width, height, frames, memtype, xpos, ypos, return ID
    {"newgame.bmp", 160, 42, 3, CDXMEM_VIDTHENSYS, 240, 202, BID_MAINMENU_CHARSELECT },
    {"setup.bmp", 92, 38, 3, CDXMEM_VIDTHENSYS, 272, 344, BID_MAINMENU_OPTIONS},
	{"exit.bmp", 68, 38, 3, CDXMEM_VIDTHENSYS, 286, 404, BID_MAINMENU_EXIT},
};
#define NUM_OF_BUTTONS_MAINMENU    sizeof(buttonMainMenu)/sizeof(buttonMainMenu[0])


static BitmapButtonInfo buttonCharSelMenu[] = 
{
    {"newgame.bmp", 160, 42, 3, CDXMEM_VIDTHENSYS, 200, 240, BID_CHARSELMENU_READY},
    {"newgame.bmp", 160, 42, 3, CDXMEM_VIDTHENSYS, 200, 280, BID_CHARSELMENU_OK},
    {"charselcancel.bmp", 100, 52, 3, CDXMEM_VIDTHENSYS, 532, 425, BID_CHARSELMENU_CANCEL},
};
#define NUM_OF_BUTTONS_CHARSELMENU    sizeof(buttonCharSelMenu)/sizeof(buttonCharSelMenu[0])



static CDXBitmapButton*	pMainMenuButtons[NUM_OF_BUTTONS_MAINMENU];
static CDXBitmapButton*	pCharSelMenuButtons[NUM_OF_BUTTONS_CHARSELMENU];




static CDXTextButton*	pTextButton;
static TextButtonInfo   textButtonInfo={"fokfokfok", RGB(255,0,0), RGB(0,255,0), RGB(0,0,255), 100, 100, 100};


#define     MOUSE_ENTER(m)                          \
int                                                 \
MouseEnter##m(POINT pt, int id)                     \
{                                                   \
    char    tmpBuf[50];                             \
    sprintf(tmpBuf, "Enter to Button %d\n", id);    \
    MessageBox(NULL, tmpBuf, "", MB_OK);            \
    return 1;                                       \
}
MOUSE_ENTER(0);
MOUSE_ENTER(1);
MOUSE_ENTER(2);


#define     PFN_MOUSE_ENTER(m)      MouseEnter##m
static MOUSECALLBACK	pMainMenuButtonsMouseEnter[NUM_OF_BUTTONS_MAINMENU] = 
{
    PFN_MOUSE_ENTER(0),
    PFN_MOUSE_ENTER(1),
    PFN_MOUSE_ENTER(2)
};


#define     MOUSE_LEAVE(m)                          \
int                                                 \
MouseLeave##m(POINT pt, int id)                     \
{                                                   \
    char    tmpBuf[50];                             \
    sprintf(tmpBuf, "Leave Button from %d\n", id);  \
    MessageBox(NULL, tmpBuf, "", MB_OK);            \
    return 1;                                       \
}
MOUSE_LEAVE(0);
MOUSE_LEAVE(1);
MOUSE_LEAVE(2);


#define     PFN_MOUSE_LEAVE(m)      MouseLeave##m
static MOUSECALLBACK	pMainMenuButtonsMouseLeave[NUM_OF_BUTTONS_MAINMENU] = 
{
    PFN_MOUSE_LEAVE(0),
    PFN_MOUSE_LEAVE(1),
    PFN_MOUSE_LEAVE(2)
};

static CDXBmpTextButton*	pBmpTextButton;
static BmpTextButtonInfo    bmpTextButtonInfo={"MY bmp Button", NULL, NULL, NULL, 100, 200, 200};

CDXBitmapFont*  g_BmpFont[3];

char*   BmpFontFile[3] =
{
    "defaultfont.bmp",
    "font2.bmp",
    "font3.bmp"
};


//////////////////////////////////////////////////////////////
// Function name : ConvertMouseToState
// Description   : This is used to convert whatever method of mouse status the game uses into
//		the mouse status flags that the CDXMenu classes handle.  Change this as you see fit.
//////////////////////////////////////////////////////////////
int ConvertMouseToState()
{
    if(theApp.m_dwMouseStatus & LMB_DOWN)
        return BUTTON_DOWN;
    else if(theApp.m_dwMouseStatus & LMB_UEDGE)
        return BUTTON_UP;

    return BUTTON_FLAG;
}


//////////////////////////////////////////////////////////////
// Function name : MenuInit
// Description   : Initialize the menu stuff
//////////////////////////////////////////////////////////////
void MenuInit()
{
	int i;

	// create and load some bitmap fonts
    for(i=0; i<3; i++)
    {
        g_BmpFont[i] = new CDXBitmapFont(theApp.m_Screen, BmpFontFile[i], CDXMEM_VIDTHENSYS);
        g_BmpFont[i]->LoadKernelTable( "tooltipfont.krn" );
        g_BmpFont[i]->SetColorKey();
    }

	//create main menu
    Menus[MID_MAINMENU] = new CDXMenu();
	Menus[MID_MAINMENU]->Create(theApp.m_Screen, MAKEPATH(PATH_DATA, "guibg.bmp"), CDXMEM_VIDTHENSYS);
	Menus[MID_MAINMENU]->SetDest(menuRect[0],menuRect[1],menuRect[2],menuRect[3]);
    Menus[MID_MAINMENU]->RegisterMouse(&CursorPos);

    for(i=0; i<NUM_OF_BUTTONS_MAINMENU; i++)
    {
        Menus[MID_MAINMENU]->AddItem(theApp.m_Screen, &buttonMainMenu[i], &pMainMenuButtons[i]);
        pMainMenuButtons[i]->SetColorKey();
		//register callback functions when mouse enters or leaves a button
        pMainMenuButtons[i]->RegisterMouseEnter(pMainMenuButtonsMouseEnter[i]);
        pMainMenuButtons[i]->RegisterMouseLeave(pMainMenuButtonsMouseLeave[i]);
    }


	// add a textButton using a truetype windows font
    Menus[MID_MAINMENU]->AddItem(theApp.m_Screen, &textButtonInfo, &pTextButton);
	pTextButton->ChangeFont("Arial", 0, 60, FW_NORMAL);

	// add a Bitmap Text button using a bitmap font
    Menus[MID_MAINMENU]->AddItem(&bmpTextButtonInfo, &pBmpTextButton);
	pBmpTextButton->AddBitmapFont(g_BmpFont[0], g_BmpFont[1], g_BmpFont[2]);


	// create tooltips
	// first tooltip has background and border, others no BG
    pMainMenuButtons[0]->m_pToolTipCtrl = new CDXToolTip(theApp.m_pToolTipFont, "Character Selection", RGB(255,255,255), RGB(0,0,0), 1);
    pMainMenuButtons[1]->m_pToolTipCtrl = new CDXToolTip(theApp.m_pToolTipFont, "Options");
    pMainMenuButtons[2]->m_pToolTipCtrl = new CDXToolTip(theApp.m_pToolTipFont, "Exit");


    theApp.m_pCurrentMenu = Menus[MID_MAINMENU];
}


//////////////////////////////////////////////////////////////
// Function name : MenuKill
// Description   : Kill menu stuff
//////////////////////////////////////////////////////////////
void MenuKill(void)
{
	int i;

	for(i=0; i<NUM_OF_MENU; i++)
	{
		delete Menus[i];
	}

    for(i=0; i<3; i++)
    {
        delete g_BmpFont[i];
    }
}

//////////////////////////////////////////////////////////////
// Function name : Menu
// Description   : Process main menu and menu item actions
//////////////////////////////////////////////////////////////
void Menu()
{
    //Initialize menu if not already.
	if(!Menus[MID_MAINMENU])
	{
		MenuInit();
	}

    if(theApp.m_pCurrentMenu!=Menus[MID_MAINMENU])
        theApp.m_pCurrentMenu = Menus[MID_MAINMENU];


	int retVal=-1;
	if (KEYDOWN(KB_UP)) {
        retVal= theApp.m_pCurrentMenu->UpMenu();
    } else if (KEYDOWN(KB_DOWN)) {
        retVal= theApp.m_pCurrentMenu->DownMenu();
    } else if (KEYDOWN(KB_RETURN)) {
        retVal= theApp.m_pCurrentMenu->EnterMenu();
    } else if (KEYDOWN(KB_HOME)) {
        retVal= theApp.m_pCurrentMenu->HomeMenu();
    } else if (KEYDOWN(KB_END)) {
        retVal= theApp.m_pCurrentMenu->EndMenu();
    } else if (KEYDOWN(KB_RIGHT)) {
        retVal= theApp.m_pCurrentMenu->GoSubMenu();
    } else if (KEYDOWN(KB_LEFT)) {
        retVal= theApp.m_pCurrentMenu->LeaveSubMenu();
    } else {
        retVal= theApp.m_pCurrentMenu->MouseMove(ConvertMouseToState());
    }

	if (retVal>0)
	{
		switch(retVal)
		{
		case BID_MAINMENU_CHARSELECT:
            SetGameState(CHARSELECTMENU);
            break;
		case BID_MAINMENU_NEWGAME:
			SetGameState(STARTGAME);
            break;
        case BID_MAINMENU_EXIT:
            SetGameState(QUITPROGRAM);
			break;

		default:
            theApp.m_pCurrentMenu = NULL;
            return;
			break;
		}
	}

	//draw the menu
	theApp.m_pCurrentMenu->DrawMenu(theApp.m_Screen->GetBack());
}


//////////////////////////////////////////////////////////////
// Function name : MenuInit
// Description   : Initialize the menu stuff
//////////////////////////////////////////////////////////////
void CharSelMenuInit()
{
	int i;

	// create new menu, set its size
    Menus[MID_CHARSELECTMENU] = new CDXMenu();
	Menus[MID_CHARSELECTMENU]->Create(theApp.m_Screen, MAKEPATH(PATH_DATA, "charselect.bmp"), CDXMEM_VIDTHENSYS);
	Menus[MID_CHARSELECTMENU]->SetDest(menuRect[4],menuRect[5],menuRect[6],menuRect[7]);
    Menus[MID_CHARSELECTMENU]->RegisterMouse(&CursorPos);

	// add buttons to this menu
    for(i=0; i<NUM_OF_BUTTONS_CHARSELMENU; i++)
    {
        Menus[MID_CHARSELECTMENU]->AddItem(theApp.m_Screen, &buttonCharSelMenu[i], &pCharSelMenuButtons[i]);
		// set transparency
        pCharSelMenuButtons[i]->SetColorKey();
    }

	// add tooltips for each item
    pCharSelMenuButtons[0]->AddToolTip(theApp.m_pToolTipFont, "Start Game");
    pCharSelMenuButtons[1]->AddToolTip(theApp.m_pToolTipFont, "Character options");
    pCharSelMenuButtons[2]->AddToolTip(theApp.m_pToolTipFont, "Main Menu");

	// set the global current menu to this menu
    theApp.m_pCurrentMenu = Menus[MID_CHARSELECTMENU];

	// initialize my characters in my character manager
	charManager.InitializeCharacters();
}


//////////////////////////////////////////////////////////////
// Function name : SelectChar
// Description   : Character Selection Menu
//////////////////////////////////////////////////////////////
void SelectChar()
{
	CDXSurface *bb = theApp.m_Screen->GetBack();

    //Initialize menu if not already.
	if(!Menus[MID_CHARSELECTMENU])
	{
		CharSelMenuInit();
	}

    if(theApp.m_pCurrentMenu!=Menus[MID_CHARSELECTMENU])
    {
        theApp.m_pCurrentMenu = Menus[MID_CHARSELECTMENU];
    }

	int retVal=-1;
    retVal = theApp.m_pCurrentMenu->MouseMove(ConvertMouseToState());

	// depending on which key was pressed...
    if (retVal>0)
	{
		switch(retVal)
		{
		case BID_CHARSELMENU_READY:
			SetGameState(STARTGAME);
			break;

        case BID_CHARSELMENU_CANCEL:
            SetGameState(MAINMENU);
			break;

		default:
            theApp.m_pCurrentMenu = NULL;
            return;
			break;
		}
	}

	//draw the menu
	theApp.m_pCurrentMenu->DrawMenu(bb);

	// draw my 10 characters names on the screen
    int i;
    for(i=0; i<10; i++)
	{
		CCharacter *character = charManager.GetCharacter(i);
        theApp.m_pDefaultBitmapFont->Print(bb, 50, i*20+20, character->GetName());
	}
}
