// tmr.cpp : Defines the entry point for the console application.
//

#define WIN32_LEAN_AND_MEAN

#include <windows.h>
#include <cdx.h>

#include "cdxhpc.h"

void simpleExample() {
	printf("SimpleExample():\n");
	CDXHPC pc;

	pc.Start();

	printf("  Start: %d\n", pc.GetValue());
	// wait for 30 ms
	pc.Wait(30);
	printf("  End: %d\n", pc.GetValue());
}

void pauseExample() {
	// This example shows how you could use two different timers in your program
	// An application of this could be if you have a global
	// timer that is used for timing animations and such, and
	// there is also a game-world timer that is used for
	// timing how long it takes for something to get done,
	// and this would allow you to pause the game-world timer
	// in order to let an animation complete, and still have your
	// animation timer running, and when the game-world timer is
	// unpaused, it will continue right where it left off
	printf("PauseExample():\n");
	CDXHPC pc1, pc2;

	pc1.Start();
	pc2.Start();
	printf("  Start1: %d\n", pc1.GetValue());
	printf("  Start2: %d\n", pc2.GetValue());
	// wait for 30 ms
	pc1.WaitFor(30);
	// Pause the first timer
	pc1.Pause();
	// Wait for 30 ms while the first is paused
	pc2.WaitFor(30);
	pc1.Resume();
	// Wait for 30 more ms
	pc1.WaitFor(30); 
	// 90 real ms have passed, and pc1 should read 60 ms
	printf("  End1: %d\n", pc1.GetValue());
	printf("  End2: %d\n", pc2.GetValue());
}


int main(int argc, char* argv[])
{
	simpleExample();

	pauseExample();

	return 0;
}

