//////////////////////////////////////////////////////////////////////////////////
// $Source: /cvsroot/cdx/cdx3.0/addons/CDXMAIN/Cdxmain.cpp,v $
// $Author: mindcry $
//
// $Log: Cdxmain.cpp,v $
// Revision 1.4  2000/12/12 16:52:18  mindcry
// Fixed several bugfixes with using this class.
// ReInit works now perfect.
// Small cleanups and optimizations.
//
// Revision 1.3  2000/08/20 10:45:35  mindcry
// Fixed some small issues
//
// Revision 1.2  2000/07/31 15:52:10  mindcry
// Improved the class in several ways:
// - Windowed mode can now have frame
// - Menu messages can be processed
// - cleaned the code here and there
//
// Revision 1.1.1.1  2000/04/22 16:50:32  hebertjo
// Initial checkin of v3.0 to SourceForge CVS.
//
// Revision 1.1  2000/03/16 13:00:00  Mindcry
// Initial checkin... Still in beta phase
//
//
// $Revision: 1.4 $
//////////////////////////////////////////////////////////////////////////////////
#ifdef SAVE_RCSID
static char rcsid[] = "@(#) $Id: Cdxmain.cpp,v 1.4 2000/12/12 16:52:18 mindcry Exp $";
#endif

#include <CDX.h>
#include "CDXMain.h"

//////////////////////////////////////////////////////////////////////////////////
// Globals (don't know how to move them into the class)
// I allways get a:
// illegal reference to data member 'CDXMain::xxx' in a static member function
//////////////////////////////////////////////////////////////////////////////////
BOOL m_bActive, m_bMouseOff, m_bSwitch, m_ReInit;
int m_MenuSelect;

//////////////////////////////////////////////////////////////////////////////////
// Default constructor.
//////////////////////////////////////////////////////////////////////////////////
CDXMain::CDXMain()
{
	m_hWnd=0;
	m_hInst=0;
	m_bActive=TRUE;
	m_bSwitch=FALSE;
	m_bMouseOff=FALSE;
	m_ReInit=FALSE;
	m_bInit=TRUE;
	m_Pos=0;
	m_hMenu=0;
	m_MenuSelect=0;
	ZeroMemory( &m_wc,sizeof(m_wc) );
}

//////////////////////////////////////////////////////////////////////////////////
// Default destructor.
//////////////////////////////////////////////////////////////////////////////////
CDXMain::~CDXMain()
{
	if(m_hMenu) DestroyMenu(m_hMenu);
}

//////////////////////////////////////////////////////////////////////////////////
// The Window Proc
// I can't add it to the class, couse then i get an compiler error
//////////////////////////////////////////////////////////////////////////////////
long PASCAL CDXMain::WProc( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam )
{
	switch( msg )
    {
		case WM_ACTIVATEAPP:
			m_bActive = wParam;
			break;
			
		case WM_CREATE:
			break;
			
		case WM_SETCURSOR:
			if( !m_bMouseOff ) SetCursor(NULL);
			else DefWindowProc( hWnd, msg, wParam, lParam);
			break;
			
		case WM_SYSKEYUP:
			if ( wParam == VK_F4) PostMessage(hWnd, WM_QUIT, 0, 0);
			if ( wParam == VK_RETURN ) m_bSwitch=TRUE;
			break;
		
		case WM_DESTROY:
			if( m_ReInit==FALSE ) PostQuitMessage( 0 );
			break;

		case WM_COMMAND:
			if( HIWORD(wParam)==NULL )
				m_MenuSelect=LOWORD(wParam);
			break;
		
		default:
			return DefWindowProc( hWnd, msg, wParam, lParam);
	}

    return 0;
}

//////////////////////////////////////////////////////////////////////////////////
// Init the window
//////////////////////////////////////////////////////////////////////////////////
HRESULT CDXMain::Init( void *hInst, char *Name, char *Icon, WORD x, WORD y, BOOL Frame, WORD MenuID )
{
	//_control87(MCW_EM, MCW_EM);  // Borland Fix
	if( hInst==0 ) return -1;
	m_hInst=(HINSTANCE)hInst;

	m_wc.style = CS_HREDRAW | CS_VREDRAW;
	m_wc.lpfnWndProc = WProc;
	m_wc.cbClsExtra = m_wc.cbWndExtra = 0;
	m_wc.hInstance = m_hInst;
	m_wc.hIcon = LoadIcon( m_hInst, Icon );
	m_wc.hCursor = LoadCursor( NULL, IDC_ARROW );
	m_wc.hbrBackground = GetStockBrush(BLACK_BRUSH);
	m_wc.lpszMenuName = Name;
	m_wc.lpszClassName = Name;
	if( !RegisterClass( &m_wc ) )	return -1;

	if( x==0 ) x=GetSystemMetrics(SM_CXSCREEN);
	if( y==0 ) y=GetSystemMetrics(SM_CYSCREEN);
	
	DWORD style = WS_POPUP;
	if( Frame ) style|=WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX;
	if( MenuID ) m_hMenu=LoadMenu(m_hInst, MAKEINTRESOURCE( MenuID ) );

#ifndef _DEBUG
	m_hWnd = CreateWindowEx( WS_EX_TOPMOST, Name,Name, style, 0,0,	x,y, NULL, m_hMenu, m_hInst, NULL );
#else
	m_hWnd = CreateWindowEx( 0, Name,Name, style, 0,0, x,y, NULL, m_hMenu, m_hInst, NULL );
#endif
	if( m_hWnd==NULL )
	{
		int i= GetLastError();
		return -1;
	}

	ShowWindow( m_hWnd, SW_SHOWNORMAL );
	UpdateWindow( m_hWnd );

	return 0;
}

//////////////////////////////////////////////////////////////////////////////////
// ReInit the window
//////////////////////////////////////////////////////////////////////////////////
HRESULT CDXMain::ReInit( char *Icon, WORD x, WORD y, BOOL Frame, WORD MenuID )
{
	//_control87(MCW_EM, MCW_EM);  // Borland Fix
	if( m_hInst==0 ) return -1;

	m_ReInit=TRUE;
	DestroyWindow( m_hWnd );
	m_ReInit=FALSE;
	UnregisterClass( m_wc.lpszClassName, m_hInst );
	if( m_hMenu )
	{
		DestroyMenu( m_hMenu );
		m_hMenu=NULL;
	}
	if( m_wc.hIcon )
	{
		DestroyIcon( m_wc.hIcon );
		m_wc.hIcon=NULL;
	}

	m_wc.hIcon = LoadIcon( m_hInst, Icon );
	if( !RegisterClass( &m_wc ) )	return -1;

	if( x==0 ) x=GetSystemMetrics(SM_CXSCREEN);
	if( y==0 ) y=GetSystemMetrics(SM_CYSCREEN);
	
	DWORD style = WS_POPUP;
	if( Frame ) style|=WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX;
	if( MenuID ) m_hMenu=LoadMenu(m_hInst, MAKEINTRESOURCE( MenuID ) );

#ifndef _DEBUG
	m_hWnd = CreateWindowEx( WS_EX_TOPMOST, m_wc.lpszClassName,m_wc.lpszClassName, style, 0,0,	x,y, NULL, m_hMenu, m_hInst, NULL );
#else
	m_hWnd = CreateWindowEx( 0, m_wc.lpszClassName,m_wc.lpszClassName, style, 0,0, x,y, NULL, m_hMenu, m_hInst, NULL );
#endif
	if( m_hWnd==NULL )
	{
		int i= GetLastError();
		return -1;
	}

	ShowWindow( m_hWnd, SW_SHOWNORMAL );
	UpdateWindow( m_hWnd );

	return 0;
}

//////////////////////////////////////////////////////////////////////////////////
// Process one single Tick
//////////////////////////////////////////////////////////////////////////////////
HRESULT CDXMain::Tick( void )
{
	if( m_hWnd==NULL ) return -1;
	MSG msg;
	if( PeekMessage( &msg, NULL, 0, 0, PM_NOREMOVE ) )
    {
		if( !GetMessage( &msg, NULL, 0, 0 ) )
		{
			DoClose( m_Pos );
			return -1;
		}

		TranslateMessage(&msg);
		DispatchMessage( &msg);

		if( m_MenuSelect )
		{
			DoMenu( m_MenuSelect );
			m_MenuSelect=0;
		}
	}
	else //if( m_bActive )
	{
		if( m_bInit )
		{	
			DoInit( m_Pos );
			m_bInit=FALSE;
		}
		else DoTick( m_Pos );
	}
	return 0;
}

//////////////////////////////////////////////////////////////////////////////////
// Loops trough the game ticks
//////////////////////////////////////////////////////////////////////////////////
HRESULT CDXMain::Loop( void )
{
	while( SUCCEEDED( Tick( ) ) );
	return 0;
}

void CDXMain::DoInit( int nr )
{

}

void CDXMain::DoTick( int nr )
{

}

void CDXMain::DoClose( int nr )
{

}

void CDXMain::DoMenu( int nr )
{

}


void CDXMain::DisplayMouse( BOOL disp )
{
	m_bMouseOff=disp;
}

void CDXMain::MessageBox( char *text, char *caption )
{
	::MessageBox(m_hWnd, text, caption, MB_OK );
}
