//////////////////////////////////////////////////////////////////////////////////
// $Source: /cvsroot/cdx/cdx3.0/addons/CDXMAIN/Cdxmain.h,v $
// $Author: mindcry $
//
// $Log: Cdxmain.h,v $
// Revision 1.3  2000/12/12 16:52:34  mindcry
// Fixed several bugfixes with using this class.
// ReInit works now perfect.
// Small cleanups and optimizations.
//
// Revision 1.2  2000/07/31 15:51:36  mindcry
// Improved the class in several ways:
// - Windowed mode can now have frame
// - Menu messages can be processed
// - cleaned the code here and there
//
// Revision 1.1.1.1  2000/04/22 16:50:32  hebertjo
// Initial checkin of v3.0 to SourceForge CVS.
//
// Revision 1.1  2000/03/16 13:00:00  Mindcry
// Initial checkin... Still in beta phase
//
//
// $Revision: 1.3 $
//////////////////////////////////////////////////////////////////////////////////
#ifndef CDXMAIN_H
#define CDXMAIN_H

//////////////////////////////////////////////////////////////////////////////////
// 
//////////////////////////////////////////////////////////////////////////////////
class CDXMain
{
public:
	CDXMain();
	~CDXMain();
	HRESULT Init( void *hInst, char *Name="CDXApp", char *Icon=0, WORD x=0, WORD y=0, BOOL Frame=FALSE, WORD MenuID=0 );
	HRESULT ReInit( char *Icon=0, WORD x=0, WORD y=0, BOOL Frame=FALSE, WORD MenuID=0 );
	HRESULT Loop( void );

	void DisplayMouse( BOOL disp=FALSE );
	void MessageBox( char *text, char *caption="Warning" );

	void SetPos( int nr ) { DoClose( m_Pos ); m_Pos=nr; m_bInit=TRUE; };
	int GetPos( void ) { return m_Pos; };

	HRESULT Tick( void );
	virtual void DoInit( int nr );
	virtual void DoTick( int nr );
	virtual void DoClose( int nr );
	virtual void DoMenu( int nr );

	HWND GetHwnd( ) { return m_hWnd; };
	HMENU GethMenu() { return m_hMenu; };
	HINSTANCE GetHinst( ) { return m_hInst; };

private:
	HWND m_hWnd;
	HINSTANCE m_hInst;
	BOOL m_bInit;
	int m_Pos;
	HMENU m_hMenu;
	WNDCLASS m_wc;

    static long PASCAL WProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
};


#endif CDXMAIN_H
