//////////////////////////////////////////////////////////////////////////////////
// $Source: /cvsroot/cdx/cdx3.0/addons/CDXReg/CDXReg.cpp,v $
// $Author: hebertjo $
//
// $Log: CDXReg.cpp,v $
// Revision 1.1.1.1  2000/04/22 16:50:09  hebertjo
// Initial checkin of v3.0 to SourceForge CVS.
//
// Revision 1.1  1999/08/02 15:28:41  Mindcry
// Initial release to CVS
//
//
// $Revision: 1.1.1.1 $
//////////////////////////////////////////////////////////////////////////////////
#ifdef SAVE_RCSID
static char rcsid[] = "@(#) $Id: CDXReg.cpp,v 1.1.1.1 2000/04/22 16:50:09 hebertjo Exp $";
#endif

#include "CDXReg.h"

//////////////////////////////////////////////////////////////////////////////////
// Default constructor.
//////////////////////////////////////////////////////////////////////////////////
CDXReg::CDXReg( void )
{	HKey=NULL;	}

//////////////////////////////////////////////////////////////////////////////////
// Constructor that will also opens a Key directly
//////////////////////////////////////////////////////////////////////////////////
CDXReg::CDXReg( char *str )
{	HKey=NULL;
	Open( str );
}

//////////////////////////////////////////////////////////////////////////////////
// Default destructor.
//////////////////////////////////////////////////////////////////////////////////
CDXReg::~CDXReg( )
{	Close( );	}

//////////////////////////////////////////////////////////////////////////////////
// Opens the given key, if it doesn't exist it will created
//////////////////////////////////////////////////////////////////////////////////
BYTE CDXReg::Open( char *str )
{  DWORD Disp;

	Close( );
	if( RegCreateKeyEx( HKEY_LOCAL_MACHINE, str, NULL, NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &HKey, &Disp ) != ERROR_SUCCESS )
		return FALSE;

	return (BYTE)Disp;
}

//////////////////////////////////////////////////////////////////////////////////
// Closes an previous opend key
//////////////////////////////////////////////////////////////////////////////////
void CDXReg::Close( void )
{ 	if( HKey )
	{	RegCloseKey( HKey );
		HKey = NULL;
	}
}

//////////////////////////////////////////////////////////////////////////////////
// Reads a byte from the key
//////////////////////////////////////////////////////////////////////////////////
BYTE CDXReg::ReadByte( char *val )
{   BYTE data;
	DWORD size = 1;

	if( HKey )
		if( RegQueryValueEx( HKey, val, NULL, NULL, &data, &size ) )
			data=0;


	return data;
}

//////////////////////////////////////////////////////////////////////////////////
// Reads a word from the key
//////////////////////////////////////////////////////////////////////////////////
WORD CDXReg::ReadWord( char *val )
{  WORD data;
	DWORD size = 2;

	if( HKey )
		if( RegQueryValueEx( HKey, val, NULL, NULL, (BYTE *)&data, &size ) )
			data=0;

	return data;
}

//////////////////////////////////////////////////////////////////////////////////
// Reads a DWORD from the key
//////////////////////////////////////////////////////////////////////////////////
DWORD CDXReg::ReadDWord( char *val )
{  DWORD data, size = 4;

	if( HKey )
		if( RegQueryValueEx( HKey, val, NULL, NULL, (BYTE *)&data, &size ) )
			data=0;

	return data;
}

//////////////////////////////////////////////////////////////////////////////////
// Reads a String from the key
//////////////////////////////////////////////////////////////////////////////////
void CDXReg::ReadString( char *val, char *data, DWORD size )
{	if( HKey )
		if( RegQueryValueEx( HKey, val, NULL, NULL, (BYTE *)data, &size ) )
			data[0]=0;
}

//////////////////////////////////////////////////////////////////////////////////
// Reads any raw data from the key
//////////////////////////////////////////////////////////////////////////////////
void CDXReg::ReadData( char *val, BYTE *data, DWORD size )
{	if( HKey )
		RegQueryValueEx( HKey, val, NULL, NULL, data, &size );
}

//////////////////////////////////////////////////////////////////////////////////
// Writes a byte to the key
//////////////////////////////////////////////////////////////////////////////////
void CDXReg::WriteByte( char *val, BYTE data )
{	if( HKey )
		RegSetValueEx( HKey, val, NULL, REG_BINARY, &data, 1 );
}

//////////////////////////////////////////////////////////////////////////////////
// Writes a WORD to the key
//////////////////////////////////////////////////////////////////////////////////
void CDXReg::WriteWord( char *val, WORD data )
{	if( HKey )
		RegSetValueEx( HKey, val, NULL, REG_BINARY, (BYTE *)&data, 2 );
}

//////////////////////////////////////////////////////////////////////////////////
// Writes a DWord to the key
//////////////////////////////////////////////////////////////////////////////////
void CDXReg::WriteDWord( char *val, DWORD data )
{	if( HKey )
		RegSetValueEx( HKey, val, NULL, REG_DWORD, (BYTE *)&data, 4 );
}

//////////////////////////////////////////////////////////////////////////////////
// Writes a string to the key
//////////////////////////////////////////////////////////////////////////////////
void CDXReg::WriteString( char *val, char *data )
{	if( HKey )
		RegSetValueEx( HKey, val, NULL, REG_SZ, (BYTE *)data, strlen( data ) );
}

//////////////////////////////////////////////////////////////////////////////////
// Writes any data to the key, don't store big data in the registry!
//////////////////////////////////////////////////////////////////////////////////
void CDXReg::WriteData( char *val, BYTE *data, DWORD size )
{	if( HKey )
		RegSetValueEx( HKey, val, NULL, REG_BINARY, data, size );
}