// FilterViewerView.cpp : implementation of the CFilterViewerView class
//

#include "stdafx.h"
#include "FilterViewer.h"
#include "..\\..\\src\\CDXSurfaceFilter.h"

#include "FilterViewerDoc.h"
#include "FilterViewerView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CFilterViewerView

IMPLEMENT_DYNCREATE(CFilterViewerView, CFormView)

BEGIN_MESSAGE_MAP(CFilterViewerView, CFormView)
	//{{AFX_MSG_MAP(CFilterViewerView)
	ON_BN_CLICKED(IDC_BUTTON1, OnUpdate)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFilterViewerView construction/destruction

CFilterViewerView::CFilterViewerView()
	: CFormView(CFilterViewerView::IDD)
{
	//{{AFX_DATA_INIT(CFilterViewerView)
	m_bDisolve = FALSE;
	m_bHorizontalWave = FALSE;
	m_bRotate = FALSE;
	m_bSpiral = FALSE;
	m_bZoom = FALSE;
	m_bVerticalWave = FALSE;
	m_bVerticalWave3D = FALSE;
	m_bHorizontalWave3D = FALSE;
	m_nDisolvePercent = 0;
	m_nHWWaves = 0.0;
	m_nHWPercent = 0.0;
	m_nHWOffset = 0.0;
	m_nVWWaves = 0.0;
	m_nVWPercent = 0.0;
	m_nVWOffset = 0.0;
	m_nHW3DWaves = 0.0;
	m_nHW3DPercent = 0.0;
	m_nHW3DOffset = 0.0;
	m_nVW3DWaves = 0.0;
	m_nSpiralAngle = 0.0;
	m_nZoomPercent = 0;
	m_nRotateAngle = 0.0;
	m_nVW3DOffset = 0.0;
	m_nVW3DPercent = 0.0;
	//}}AFX_DATA_INIT
	// TODO: add construction code here

}

CFilterViewerView::~CFilterViewerView()
{
}

void CFilterViewerView::DoDataExchange(CDataExchange* pDX)
{
	CFormView::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFilterViewerView)
	DDX_Check(pDX, IDC_CHECK1, m_bDisolve);
	DDX_Check(pDX, IDC_CHECK2, m_bHorizontalWave);
	DDX_Check(pDX, IDC_CHECK6, m_bRotate);
	DDX_Check(pDX, IDC_CHECK7, m_bSpiral);
	DDX_Check(pDX, IDC_CHECK8, m_bZoom);
	DDX_Check(pDX, IDC_CHECK3, m_bVerticalWave);
	DDX_Check(pDX, IDC_CHECK5, m_bVerticalWave3D);
	DDX_Check(pDX, IDC_CHECK4, m_bHorizontalWave3D);
	DDX_Text(pDX, IDC_EDIT1, m_nDisolvePercent);
	DDX_Text(pDX, IDC_EDIT2, m_nHWWaves);
	DDX_Text(pDX, IDC_EDIT3, m_nHWPercent);
	DDX_Text(pDX, IDC_EDIT4, m_nHWOffset);
	DDX_Text(pDX, IDC_EDIT5, m_nVWWaves);
	DDX_Text(pDX, IDC_EDIT6, m_nVWPercent);
	DDX_Text(pDX, IDC_EDIT7, m_nVWOffset);
	DDX_Text(pDX, IDC_EDIT8, m_nHW3DWaves);
	DDX_Text(pDX, IDC_EDIT9, m_nHW3DPercent);
	DDX_Text(pDX, IDC_EDIT10, m_nHW3DOffset);
	DDX_Text(pDX, IDC_EDIT11, m_nVW3DWaves);
	DDX_Text(pDX, IDC_EDIT15, m_nSpiralAngle);
	DDX_Text(pDX, IDC_EDIT16, m_nZoomPercent);
	DDX_Text(pDX, IDC_EDIT14, m_nRotateAngle);
	DDX_Text(pDX, IDC_EDIT13, m_nVW3DOffset);
	DDX_Text(pDX, IDC_EDIT12, m_nVW3DPercent);
	//}}AFX_DATA_MAP
}

BOOL CFilterViewerView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CFormView::PreCreateWindow(cs);
}

void CFilterViewerView::OnInitialUpdate()
{
	CFormView::OnInitialUpdate();
	GetParentFrame()->RecalcLayout();
	ResizeParentToFit();

	CWnd* tmpwnd;
	
	tmpwnd = GetDlgItem(IDC_SPIN1);

	SendDlgItemMessage(IDC_SPIN1,  UDM_SETRANGE, 0, MAKELONG (1000, 0));
	SendDlgItemMessage(IDC_SPIN2,  UDM_SETRANGE, 0, MAKELONG (1000, 0));
	SendDlgItemMessage(IDC_SPIN3,  UDM_SETRANGE, 0, MAKELONG (1000, 0));
	SendDlgItemMessage(IDC_SPIN4,  UDM_SETRANGE, 0, MAKELONG (1000, 0));
	SendDlgItemMessage(IDC_SPIN5,  UDM_SETRANGE, 0, MAKELONG (1000, 0));
	SendDlgItemMessage(IDC_SPIN6,  UDM_SETRANGE, 0, MAKELONG (1000, 0));
	SendDlgItemMessage(IDC_SPIN7,  UDM_SETRANGE, 0, MAKELONG (1000, 0));
	SendDlgItemMessage(IDC_SPIN8,  UDM_SETRANGE, 0, MAKELONG (1000, 0));
	SendDlgItemMessage(IDC_SPIN9,  UDM_SETRANGE, 0, MAKELONG (1000, 0));
	SendDlgItemMessage(IDC_SPIN10, UDM_SETRANGE, 0, MAKELONG (1000, 0));
	SendDlgItemMessage(IDC_SPIN11, UDM_SETRANGE, 0, MAKELONG (1000, 0));
	SendDlgItemMessage(IDC_SPIN12, UDM_SETRANGE, 0, MAKELONG (1000, 0));
	SendDlgItemMessage(IDC_SPIN13, UDM_SETRANGE, 0, MAKELONG (1000, 0));
	SendDlgItemMessage(IDC_SPIN14, UDM_SETRANGE, 0, MAKELONG (1000, -1000));
	SendDlgItemMessage(IDC_SPIN15, UDM_SETRANGE, 0, MAKELONG (1000, -1000));
	SendDlgItemMessage(IDC_SPIN16, UDM_SETRANGE, 0, MAKELONG (1000, -1000));


}

/////////////////////////////////////////////////////////////////////////////
// CFilterViewerView diagnostics

#ifdef _DEBUG
void CFilterViewerView::AssertValid() const
{
	CFormView::AssertValid();
}

void CFilterViewerView::Dump(CDumpContext& dc) const
{
	CFormView::Dump(dc);
}

CFilterViewerDoc* CFilterViewerView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CFilterViewerDoc)));
	return (CFilterViewerDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CFilterViewerView message handlers

void CFilterViewerView::OnUpdate() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);

	CDXSurfaceFilter* filter = (((CFilterViewerDoc*)m_pDocument)->GetCDXSurfaceFilter());

	

	filter->Reset();

	if(m_bDisolve) 
	{
		filter->Disolve(m_nDisolvePercent);
	}
	if(m_bHorizontalWave) 
	{
		filter->HorizontalWave(m_nHWWaves, m_nHWPercent, m_nHWOffset);
	}
	if(m_bVerticalWave) 
	{
		filter->VerticalWave(m_nVWWaves, m_nVWPercent, m_nVWOffset);
	}
	if(m_bHorizontalWave3D) 
	{	
		filter->HorizontalWave3D(m_nHW3DWaves, m_nHW3DPercent, m_nHW3DOffset);
	}
	if(m_bVerticalWave3D) 
	{
		filter->VerticalWave3D(m_nVW3DWaves, m_nVW3DPercent, m_nVW3DOffset);
	}
	if(m_bZoom) 
	{	
		filter->Zoom(m_nZoomPercent);
	}	
	if(m_bRotate) 
	{	
		filter->Rotate(m_nRotateAngle);
	}
	if(m_bSpiral) 
	{
		filter->Spiral(m_nSpiralAngle);
	}



	
}
