/********************************************************************
 *
 *   Author:			Robert Karlsson
 *
 *   Module:			CDXSurfaceFilter.h
 *
 *   $Workfile: $
 *   $Revision: 1.1.1.1 $
 *   $Date: 2000/04/22 16:49:15 $
 *
 *   Description:		Interface for the CDXSurfaceFilter class.
 *
 *   Dependencies:	
 *
 ********************************************************************/

#if !defined(AFX_CDXSURFACEFILTER_H__D98CEF80_DB29_11D2_BDF4_0000E86752EE__INCLUDED_)
#define AFX_CDXSURFACEFILTER_H__D98CEF80_DB29_11D2_BDF4_0000E86752EE__INCLUDED_

/*** Include files **************************************************/
//#include <cdx.h>

/*** Defines ********************************************************/

/*** Macros *********************************************************/

/*** Data types definitions and typedefs ****************************/

/*** External class declarations ************************************/
class CDXSurface;

/********************************************************************/
/*** Class definitions **********************************************/
/********************************************************************/
class CDXSurfaceFilter  
{
/*** Public Member Functions ****************************************/
public:
	CDXSurfaceFilter(CDXSurface* pSurface);
	virtual ~CDXSurfaceFilter();

	CDXSurface* GetSurface();

	void Reset();
	void Snapshot();

	void Disolve(const unsigned int percent);
	void Spiral(double angle);
	void Rotate(double angle);
	void Zoom(int percent);
	void VerticalWave(double nWaves,double percent,double offset);
	void HorizontalWave(double nWaves,double percent,double offset);
	void VerticalWave3D(double nWaves,double percent, double offset);
	void HorizontalWave3D(double nWaves,double percent, double offset);

/*** Protected Member Functions *************************************/
protected:

/*** Protected Member Variables *************************************/
protected:

/*** Private Member Functions ***************************************/
private:

/*** Private Member Variables ***************************************/
private:
	int					m_nWidth;
	int					m_nHeight;
	int					m_nCenterX;
	int					m_nCenterY;
	DWORD					m_nColorKey;

	CDXSurface*			m_pSurface;
	CDXSurface*			m_pSurfaceCopy;

};

#endif // !defined(AFX_CDXSURFACEFILTER_H__D98CEF80_DB29_11D2_BDF4_0000E86752EE__INCLUDED_)

/*
 * $History: $
 *
 */

/* EOF */
