/********************************************************************
 *
 *   Author:			Robert Karlsson
 *
 *   Module:			CDXSurfaceFilterAnimation.cpp
 *
 *   $Workfile: $
 *   $Revision: 1.1.1.1 $
 *   $Date: 2000/04/22 16:49:15 $
 *
 *   Description:		Implementation of the CDXSurfaceFilterAnimation class.
 *
 *   Usage:		
 *
 *   Dependencies:	
 *
 ********************************************************************/

/*** Include files **************************************************/
#include "CDXSurfaceFilterAnimation.h"
#include "CDXSurfaceFilter.h"

/*** Defines ********************************************************/

/*** Macros *********************************************************/

/*** Data types definitions and typedefs ****************************/

/*** Global variables ***********************************************/

/********************************************************************/
/*** Class constructor/destructor ***********************************/
/********************************************************************/
/*********************************************************************
 *
 *   Purpose:			
 *
 *   Inparameters:	
 *
 *   Outparameters:	
 *
 *   Return value:
 *
 *   Note:
 *
 */
CDXSurfaceFilterAnimation::CDXSurfaceFilterAnimation(CallBackPtr fPtr, CDXSurfaceFilter* filter, int frames) : m_pfnFunc(fPtr), m_pFilter(filter), m_nFrames(frames)
{
	// Create the thread
	m_hThread =  CreateThread(NULL,					// pointer to security attributes
									  0,						// initial thread stack size
									  &RenderThreadFunc, // pointer to thread function
									  this,              // argument for new thread
									  0,                 // creation flags
									  &m_nThreadID       // pointer to receive thread ID
									  );
	
	m_nCurrentFrame = 0;

}

/*********************************************************************
 *
 *   Purpose:			
 *
 *   Inparameters:	
 *
 *   Outparameters:	
 *
 *   Return value:
 *
 *   Note:
 *
 */
CDXSurfaceFilterAnimation::~CDXSurfaceFilterAnimation()
{
	// Lame deletion, dont remember the whole array creation/deletion syntax...
	
	for(int i=0;i<m_nFrames;i++)
		delete m_pSurfaceArray[i];
}

/********************************************************************/
/*** Static "Member" Functions ****************************************/
/********************************************************************/
/*********************************************************************
 *
 *   Purpose:			Call user provided callback function frame times in a thread.
 *							And call callback with -1 as current framecount when finished.
 *
 *   Inparameters:	pArguments				Pointer to the this class(needed since this is a static function)
 *
 *   Outparameters:	None.
 *
 *   Return value:	DWORD						Always 0
 *
 *   Note:
 *
 */
DWORD WINAPI CDXSurfaceFilterAnimation::RenderThreadFunc(void *pArguments)
{
	CDXSurfaceFilterAnimation* pSurfaceFilterAnimation = (CDXSurfaceFilterAnimation*) pArguments;

	// Render scene
	for(int i=0;i<pSurfaceFilterAnimation->m_nFrames;i++)
	{
		// Invoke callback function
		pSurfaceFilterAnimation->m_pfnFunc(i, pSurfaceFilterAnimation->m_pFilter);
		// Draw the current surface into the array
		pSurfaceFilterAnimation->m_pSurfaceArray[i] = new CDXSurface(*pSurfaceFilterAnimation->m_pFilter->GetSurface());
	}

	// Tell callback function that we are done here.
	pSurfaceFilterAnimation->m_pfnFunc(-1, NULL);
	return 0;

}

/*********************************************************************
 *
 *   Purpose:			Return the next frame in the animation
 *
 *   Inparameters:	
 *
 *   Outparameters:	
 *
 *   Return value:
 *
 *   Note:
 *
 */
CDXSurface* CDXSurfaceFilterAnimation::NextFrame()
{
	if(++m_nCurrentFrame == m_nFrames)
	{
		Rewind();
		return NULL;
	}
	else
	{
		return m_pSurfaceArray[m_nCurrentFrame];
	}
}

/*********************************************************************
 *
 *   Purpose:			
 *
 *   Inparameters:	
 *
 *   Outparameters:	
 *
 *   Return value:
 *
 *   Note:
 *
 */
void CDXSurfaceFilterAnimation::MoveToLastFrame()
{
	m_nCurrentFrame = m_nFrames;
}

/*********************************************************************
 *
 *   Purpose:			
 *
 *   Inparameters:	
 *
 *   Outparameters:	
 *
 *   Return value:
 *
 *   Note:
 *
 */
CDXSurface* CDXSurfaceFilterAnimation::PreviousFrame()
{
	if(--m_nCurrentFrame == -1)
	{
		Rewind();
		return NULL;
	}
	else
	{
		return m_pSurfaceArray[m_nCurrentFrame];
	}

}

/********************************************************************/
/*** Public Member Functions ****************************************/
/********************************************************************/

/********************************************************************/
/*** Protected Member Functions *************************************/
/********************************************************************/

/********************************************************************/
/*** Private Member Functions ***************************************/
/********************************************************************/
/*********************************************************************
 *
 *   Purpose:			
 *
 *   Inparameters:	
 *
 *   Outparameters:	
 *
 *   Return value:
 *
 *   Note:
 *
 */
void CDXSurfaceFilterAnimation::Rewind()
{
	m_nCurrentFrame = 0;
}

/*
 * $History: $
 *
 */

/* EOF */

