/********************************************************************
 *
 *   Author:			Robert Karlsson
 *
 *   Module:			CDXSurfaceFilterAnimation.h
 *
 *   $Workfile: $
 *   $Revision: 1.1.1.1 $
 *   $Date: 2000/04/22 16:49:16 $
 *
 *   Description:		Interface for the CDXSurfaceFilterAnimation class.
 *
 *   Dependencies:	
 *
 ********************************************************************/

#if !defined(AFX_CDXSURFACEFILTERANIMATION_H__27DFA422_DE9F_11D2_BDF4_0000E86752EE__INCLUDED_)
#define AFX_CDXSURFACEFILTERANIMATION_H__27DFA422_DE9F_11D2_BDF4_0000E86752EE__INCLUDED_

/*** Include files **************************************************/
#include <cdx.h>
/*** Defines ********************************************************/

/*** Macros *********************************************************/

/*** External class declarations ************************************/
class CDXSurfaceFilter;

/*** Data types definitions and typedefs ****************************/
typedef void (*CallBackPtr)(int						currentframe,
                            CDXSurfaceFilter*	filter
									);

/********************************************************************/
/*** Class definitions **********************************************/
/********************************************************************/
class CDXSurfaceFilterAnimation  
{
/*** Public Member Functions ****************************************/
public:
	CDXSurface* PreviousFrame();
	void MoveToLastFrame();
	void Rewind();
	CDXSurfaceFilterAnimation(CallBackPtr fPtr, CDXSurfaceFilter* filter, int frames);
	virtual ~CDXSurfaceFilterAnimation();

	CDXSurface* NextFrame();
	
	int m_nCurrentFrame;

/*** Protected Member Functions *************************************/
protected:

/*** Protected Member Variables *************************************/
protected:

/*** Private Member Functions ***************************************/
private:
	static DWORD WINAPI RenderThreadFunc( void* pArguments );

/*** Private Member Variables ***************************************/
private:
	CallBackPtr			m_pfnFunc;       // function to call when callback is made
	CDXSurfaceFilter*	m_pFilter;
	int					m_nFrames;

	HANDLE				m_hThread;
   DWORD					m_nThreadID;

	enum { MAX_FRAMES = 100 };			// The "enum" hack
	CDXSurface*			m_pSurfaceArray[MAX_FRAMES];

};

#endif // !defined(AFX_CDXSURFACEFILTERANIMATION_H__27DFA422_DE9F_11D2_BDF4_0000E86752EE__INCLUDED_)

/*
 * $History: $
 *
 */

/* EOF */