// MainFrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "ex6.h"

#include "MainFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_KEYDOWN()
	ON_WM_TIMER()
	ON_WM_SETCURSOR()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
	// TODO: add member initialization code here
	mb_Active=TRUE;
}

CMainFrame::~CMainFrame()
{
	delete Map;
	delete Tiles;
	delete screen;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CFrameWnd::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers

BOOL CMainFrame::InitDirectDraw()
{
	HWND hWnd = AfxGetMainWnd()->m_hWnd;
	screen = new CDXScreen();
	screen->CreateFullScreen(hWnd,640,400,8);

	screen->LoadPalette("ANIM.BMP");
	// Load the tiles
	Tiles = new CDXTile;
	Tiles->Create(screen, "ANIM.BMP", 64, 64, 0);

	// Create and load the map
	Map = new CDXMap(Tiles, screen);
	Map->Create(63,63, 1);
	Map->MoveTo(0,0);

	Map->EnableScrollWrapping(TRUE);

	int Tile = 1 , i  , j;

	for( i=0; i<63; i++ )
		for( j=0; j<63; j++ )
		{
			Map->SetTile( i , j , Tile++ );
			if( Tile > 4 ) Tile = 1;
		}

	Run();
	return TRUE;
}

BOOL CMainFrame::LoadFrame(UINT nIDResource, DWORD dwDefaultStyle, CWnd* pParentWnd, CCreateContext* pContext) 
{
	CString sClassName = ::AfxRegisterWndClass(CS_HREDRAW | CS_VREDRAW);
	if (!Create(sClassName, NULL, dwDefaultStyle, rectDefault,
                pParentWnd, NULL, 0L, pContext))
	  {
		return FALSE;
	  }
	
	return TRUE;
}

void CMainFrame::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	switch (nChar)
	{
		case VK_ESCAPE:
			{
				screen->FadeOut(4);
				PostMessage(WM_CLOSE, 0, 0);
				mb_Active=FALSE;
				break;
			}
	}
	CFrameWnd::OnKeyDown(nChar, nRepCnt, nFlags);
}


BOOL CMainFrame::OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message) 
{
	SetCursor(NULL);

	return TRUE;
}

void CMainFrame::Run()
{
	MSG msg;
	int Delay=0;
	RECT Window = { 0, 0, 640, 400 };

while(mb_Active)
	{
		if (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))	
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
		else
		{
			// Clear the back buffer
			screen->Fill(0);

			int i , j , Tile;

			if(++Delay > 40)
			{
				for( j=0; j<63; j++ )
					for( i=0; i<63; i++ )
					{
						Tile = Map->GetTile( i , j );
						++ Tile;
						if( Tile > 4 ) Tile = 1;
						Map->SetTile( i , j , Tile );
					}
					Delay = 0;
			}

			if(GetAsyncKeyState(VK_UP))    Map->ScrollUp(2);
			if(GetAsyncKeyState(VK_DOWN))  Map->ScrollDown(2);
			if(GetAsyncKeyState(VK_LEFT))  Map->ScrollLeft(2);
			if(GetAsyncKeyState(VK_RIGHT)) Map->ScrollRight(2);

			// Draw the map to the back buffer
			Map->DrawClipped(screen->GetBack(), &Window);
	
			// Then display it
			screen->Flip();
		}
	}	
}
