// MainFrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "ex7.h"

#include "MainFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_KEYDOWN()
	ON_WM_TIMER()
	ON_WM_SETCURSOR()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
	// TODO: add member initialization code here
	mb_Active=TRUE;
}

CMainFrame::~CMainFrame()
{
	delete Map1;
	delete Map2;
	delete Map3;
	delete Map4;
	delete Tiles;
	delete screen;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CFrameWnd::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers

BOOL CMainFrame::InitDirectDraw()
{
	HWND hWnd = AfxGetMainWnd()->m_hWnd;
	screen = new CDXScreen();
	screen->CreateFullScreen(hWnd,640,480,8);

	screen->LoadPalette("ANIM.BMP");
	// Load the tiles
	Tiles = new CDXTile;
	Tiles->Create(screen, "ANIM.BMP", 64, 64, 0);

	// Create and load the map
	Map1 = new CDXMap(Tiles, screen);
	Map1->Create(64, 64, 1);

	Map1->EnableScrollWrapping(TRUE);

	Map2 = new CDXMap(Tiles, screen);
	Map2->Create(64, 64, 2);

	Map2->EnableScrollWrapping(TRUE);

	Map3 = new CDXMap(Tiles, screen);
	Map3->Create(64, 64, 3);
	
	Map3->EnableScrollWrapping(TRUE);

	Map4 = new CDXMap(Tiles, screen);
	Map4->Create(64, 64, 4);

	Map4->EnableScrollWrapping(TRUE);

	Run();
	return TRUE;
}

BOOL CMainFrame::LoadFrame(UINT nIDResource, DWORD dwDefaultStyle, CWnd* pParentWnd, CCreateContext* pContext) 
{
	CString sClassName = ::AfxRegisterWndClass(CS_HREDRAW | CS_VREDRAW);
	if (!Create(sClassName, NULL, dwDefaultStyle, rectDefault,
                pParentWnd, NULL, 0L, pContext))
	  {
		return FALSE;
	  }
	
	return TRUE;
}

void CMainFrame::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	switch (nChar)
	{
		case VK_ESCAPE:
			{
				screen->FadeOut(4);
				PostMessage(WM_CLOSE, 0, 0);
				mb_Active=FALSE;
				break;
			}
	}
	CFrameWnd::OnKeyDown(nChar, nRepCnt, nFlags);
}


BOOL CMainFrame::OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message) 
{
	SetCursor(NULL);

	return TRUE;
}

void CMainFrame::Run()
{
	MSG msg;
	RECT Window1 = { 0, 0, 320, 240 };
	RECT Window2 = { 320, 0, 640, 240 };
	RECT Window3 = { 0, 240, 640, 480 };
	RECT Window4 = { 320, 240, 640, 480 };

	while(mb_Active)
	{
		if (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))	
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
		else
		{
			// Clear the back buffer
			screen->Fill(0);

			if(GetAsyncKeyState(VK_UP))
			{
				Map1->ScrollUp(2);
				Map2->ScrollUp(2);
				Map3->ScrollUp(2);
				Map4->ScrollUp(2);
			}
			if(GetAsyncKeyState(VK_DOWN))
			{
				Map1->ScrollDown(2);
				Map2->ScrollDown(2);
				Map3->ScrollDown(2);
				Map4->ScrollDown(2);
			}
			if(GetAsyncKeyState(VK_LEFT))
			{
				Map1->ScrollLeft(2);
				Map2->ScrollLeft(2);
				Map3->ScrollLeft(2);
				Map4->ScrollLeft(2);
			}
			if(GetAsyncKeyState(VK_RIGHT))
			{
				Map1->ScrollRight(2);
				Map2->ScrollRight(2);
				Map3->ScrollRight(2);
				Map4->ScrollRight(2);
			}

			// Draw the map to the back buffer
			Map1->DrawClipped(screen->GetBack(), &Window1);
			Map2->DrawClipped(screen->GetBack(), &Window2);
			Map3->DrawClipped(screen->GetBack(), &Window3);
			Map4->DrawClipped(screen->GetBack(), &Window4);
		
			// Then flip it			
			screen->Flip();
	
		}
	}	
}
