//////////////////////////////////////////////////////////////////////////////////
// $Source: /cvsroot/cdx/cdx3.0/examples/other/CDXMappyDemo/CDXMappy.h,v $
// $Author: istan $
//
// $Log: CDXMappy.h,v $
// Revision 1.1  2001/02/18 05:39:13  istan
// Added to the repository
//
//
// $Revision: 1.1 $
//////////////////////////////////////////////////////////////////////////////////
//
// CDXMappy
//
// (c) based on on sources of Robin Burrows / rburrows@bigfoot.com.
// Mappy homepage. The current Homepage for Mappy is: 
// http://www.geocities.com/SiliconValley/Vista/7336/robmpy.htm
//
// Ported to CDX and modified by Ioannis Karagiorgos / Ioannis.Karagiorgos@gmx.de
//
//

#ifndef CDXMAPPY_H
#define CDXMAPPY_H



#include <cdx.h>
#include "cdxscreen.h"
#include "cdxsurface.h"


#if DIRECTDRAW_VERSION >= CDX_DDVER
    #define RBDIRECTDRAW LPDIRECTDRAW7
    #define RBDIRECTDRAWSURFACE LPDIRECTDRAWSURFACE7
    #define RBSURFACEDESC DDSURFACEDESC2
#else
    #define RBDIRECTDRAW LPDIRECTDRAW
    #define RBDIRECTDRAWSURFACE LPDIRECTDRAWSURFACE
    #define RBSURFACEDESC DDSURFACEDESC
#endif


#define MER_NONE 0			/* All the horrible things that can go wrong */
#define MER_OUTOFMEM 1
#define MER_MAPLOADERROR 2
#define MER_NOOPEN 3

#define AN_END -1					/* Animation types, AN_END = end of anims */
#define AN_NONE 0					/* No anim defined */
#define AN_LOOPF 1					/* Loops from start to end, then jumps to start etc */
#define AN_LOOPR 2					/* As above, but from end to start */
#define AN_ONCE 3					/* Only plays once */
#define AN_ONCEH 4					/* Only plays once, but holds end frame */
#define AN_PPFF 5					/* Ping Pong start-end-start-end-start etc */
#define AN_PPRR 6					/* Ping Pong end-start-end-start-end etc */
#define AN_PPRF 7					/* Used internally by playback */
#define AN_PPFR 8					/* Used internally by playback */
#define AN_ONCES 9					/* Used internally by playback */

typedef struct {					/* Structure for data blocks */
 RBDIRECTDRAWSURFACE bgoff , fgoff;	/* offsets from start of graphic blocks */
 RBDIRECTDRAWSURFACE fgoff2, fgoff3; /* more overlay blocks */
 unsigned long int  user1, user2;	/* user long data */
 unsigned short int user3, user4;	/* user short data */
 unsigned char user5, user6, user7;	/* user byte data */
 unsigned char tl : 1;				/* bits for collision detection */
 unsigned char tr : 1;
 unsigned char bl : 1;
 unsigned char br : 1;
 unsigned char trigger : 1;			/* bit to trigger an event */
 unsigned char unused1 : 1;
 unsigned char unused2 : 1;
 unsigned char unused3 : 1;
} BLKSTR;

typedef struct {					/* Animation control structure */
    signed char antype;				/* Type of anim, AN_? */
    signed char andelay;			/* Frames to go before next frame */
    signed char ancount;			/* Counter, decs each frame, till 0, then resets to andelay */
    signed char anuser;				/* User info */
    long int    ancuroff;			/* Points to current offset in list */
    long int    anstartoff;			/* Points to start of blkstr offsets list, AFTER ref. blkstr offset */
    long int    anendoff;			/* Points to end of blkstr offsets list */
} ANISTR;

typedef struct {					/* Generic structure for chunk headers */
    char id1, id2, id3, id4;		/* 4 byte header id. */
    long int headsize;				/* size of header chunk. */
} GENHEAD;

typedef struct {					/* Map header structure */
    char mapverhigh;				/* map version number to left of . (ie X.0). */
	char mapverlow;					/* map version number to right of . (ie 0.X). */
	char lsb;						/* if 1, data stored LSB first, otherwise MSB first. */
	char reserved;
	short int mapwidth;				/* width in blocks. */
	short int mapheight;			/* height in blocks. */
	short int reserved1;
	short int reserved2;
	short int blockwidth;			/* width of a block (tile) in pixels. */
	short int blockheight;			/* height of a block (tile) in pixels. */
	short int blockdepth;			/* depth of a block (tile) in planes (ie. 256 colours is 8) */
	short int blockstrsize;			/* size of a block data structure */
	short int numblockstr;			/* Number of block structures in BKDT */
	short int numblockgfx;			/* Number of 'blocks' in graphics (BGFX) */
} MPHD;


class CDXMappy
{
private:

	/* These define the width and height of the drawn area... */
	int			MSCRW;
	int			MSCRH;

	/* These define how far from the left and top of the surface the drawn area is */
	int			MMOX;
	int			MMOY;

	/* These define the block size */
	int			MBSW;				/* Width of block, in pixels */
	int			MBSH;				/* Height of block, in pixels */

    // These are for the parallax surface
    int         PARAW;              // width of the parallax surface - blockwidth
    int         PARAH;              // height of the parallax surface - blockheight

	/* These define the colorkey settings */
	int			MTRANSP8;			/* Transparency index for paletted screen (0 to 255)*/
	int			MTRANSPR;			/* 8bit RED transparency value for high/true colour */
	int			MTRANSPG;			/* 8bit GREEN transparency value for high/true colour */
	int			MTRANSPB;			/* 8bit BLUE transparency value for high/true colour */

	int			maperror;					/* Set to a MER_ error if something wrong happens */
	short int	mapwidth, 
				mapheight, 
				mapblockwidth,
				mapblockheight, 
				mapdepth;
	short int	mapblockstrsize, 
				mapnumblockstr, 
				mapnumblockgfx;

	FILE		* mapfilept;
	short int	* mappt;
	short int	** maparraypt;
	unsigned char * mapcmappt;
	char		* mapblockgfxpt;
	char		* mapblockstrpt;
	char		* mapanimstrpt;
	char		* mapanimstrendpt;

	RBDIRECTDRAWSURFACE maplpDDSTiles[1024];	// tiles directdraw surfaces
	short int * mapmappt[8];
	short int ** mapmaparraypt[8];
	PALETTEENTRY mappept[256];
	GENHEAD		mapgenheader;

    int         XPosition , YPosition;          // X/Y position of the map
    CDXSurface *ParallaxSurface;                // parallax surface object
    CDXScreen  *ScreenObject;                   // the screen object for CDX
    char       *ParallaxFilename;               // filename of the parallax .bmp
    
public:

	~CDXMappy();
	CDXMappy( void );

    BOOL                CreateParallax( char * Filename );
    int                 DrawParallax (CDXSurface * lpDDS );
    BOOL                RestoreParallax( void );

	int LoadMap(		CDXScreen * Screen , char * Filename , 
						int left , int top , int width , int height );

	void				SetColorKey( DWORD Key );
    WORD                GetMapBPP( void );
	WORD				GetMapWidth( void );
	WORD				GetMapHeight( void );
	WORD				GetMapWidthInBlocks( void );
	WORD				GetMapHeightInBlocks( void );
	WORD				GetMapBlockWidth( void );
	WORD				GetMapBlockHeight( void );
	void				MapInitAnims (void);
	void				MapUpdateAnims (void);
    void                MapMoveTo( int x , int y );
    int                 MapGetXPosition( void ) { return XPosition; };
    int                 MapGetYPosition( void ) { return YPosition; };
	int					MapDrawBG (CDXSurface * lpDDS);
	int					MapDrawBGT (CDXSurface * lpDDS);
	int					MapDrawFG (CDXSurface * lpDDS , int mapfg=0);
	BLKSTR *			MapGetBlock (int x, int y);
	void				MapSetBlock (int x, int y, int strvalue);
	int					MapGetTile (int x , int y);
	int					MapRestore (void);

	unsigned long int	Mapbyteswapl (unsigned long int i);
	void				MapFreeMem (void);
	int					MapGenerateYLookup (void);
	int					MapChangeLayer (int newlyr);
	void				MapCMAPtoPE (unsigned char * mycmappt, PALETTEENTRY * mypept);
	int					MapHighTo8 (void);
	int					MapCopyBlocksToSurfaces (void);
	DWORD				MapTranspToPixel (LPDDPIXELFORMAT lpDDpf);
	int					MapRelocate (RBDIRECTDRAW lpDD);
	int					MapDecodeMPHD (void);
	int					MapDecodeCMAP (void);
	int					MapDecodeBKDT (void);
	int					MapDecodeANDT (void);
	int					MapDecodeBGFX (void);
	int					MapDecodeBODY (void);
	int					MapDecodeLYR1 (void);
	int					MapDecodeLYR2 (void);
	int					MapDecodeLYR3 (void);
	int					MapDecodeLYR4 (void);
	int					MapDecodeLYR5 (void);
	int					MapDecodeLYR6 (void);
	int					MapDecodeLYR7 (void);
	int					MapDecodeNULL (void);
	int					MapLoad (char * mapname, RBDIRECTDRAW lpDD);
	int					MapMemDecodeMPHD (MPHD * mapmempt);
	int					MapMemDecodeCMAP (unsigned char * cmppt);
	int					MapMemDecodeBKDT (unsigned char * mapmempt);
	int					MapMemDecodeANDT (unsigned char * mapmempt);
	int					MapMemDecodeBGFX (unsigned char * mapmempt);
	int					MapMemDecodeBODY (unsigned char * mapmempt);
	int					MapMemDecodeLYR (unsigned char * mapmempt, int maplayernum);
	int					MapDecode (unsigned char * mapmempt, RBDIRECTDRAW lpDD);
};

#endif