#include "cdxguimgr.h"



bool Inside(POINT Point, RECT ClipRect)
{
	if ( (Point.x >= ClipRect.left) && 
		 (Point.x <= ClipRect.right) && 
		 (Point.y >= ClipRect.top) &&
		 (Point.y <= ClipRect.bottom))
		return true;
	else
		return false;
}





void CDXDlgMgr::Trigger(CDXDlg* pDlg, TriggerAction Trigger)
{
// call appropriate routine depending on the action trigger

}


BYTE CDXDlgMgr::LMBDown(void)
{
	return mpInput->GetKeyState((BYTE)CDXKEY_MOUSELEFT);
}

BYTE CDXDlgMgr::RMBDown(void)
{
	return mpInput->GetKeyState((BYTE)CDXKEY_MOUSERIGHT);
}



void CDXDlgMgr::Trigger(void)
{
CDXDlgMgrEntry* pPtr;
pPtr = mpDlgHead;
bool inside;
bool InsideDefault;
bool	LMBPressed;
bool	RMBPressed;

this->UpdateMouse();

RMBPressed=RMBDown()==CDXKEY_PRESS;
LMBPressed=LMBDown()==CDXKEY_PRESS;

if (RMBPressed)
{
	fprintf(Logfile, "RMB Pressed\n");
	fflush(Logfile);

}
if (LMBPressed)
{
	fprintf(Logfile, "LMB Pressed\n");
	fflush(Logfile);
}

InsideDefault = Inside(mMouse, mDefaultRect);

//if (mCheckTriggers && !InsideDefault)
if (mCheckTriggers && InsideDefault)
while (pPtr != NULL)
	{
	if (pPtr->spDlg->Visible)
	{
		this->UpdateMouse();
		inside = Inside(mMouse, pPtr->spDlg->ClientRect);

		if (inside && pPtr->spDlg->HasFocus)
		{
			if (pPtr->spDlg->pOnMouseOver)
				(*pPtr->spDlg->pOnMouseOver)(pPtr->spDlg, mpInput);

			if (LMBPressed && !pPtr->spDlg->LMWasPressed)
				if (pPtr->spDlg->pOnMouseDown)
					(*pPtr->spDlg->pOnMouseDown)(pPtr->spDlg, mpInput);

			if (!LMBPressed && pPtr->spDlg->LMWasPressed)
				if (pPtr->spDlg->pOnMouseUp)
					(*pPtr->spDlg->pOnMouseUp)(pPtr->spDlg, mpInput);
		}
		if (inside && !pPtr->spDlg->HasFocus)
		{
			if (pPtr->spDlg->pOnGainFocus)
				(*pPtr->spDlg->pOnGainFocus)(pPtr->spDlg);
		}
		if (!inside && pPtr->spDlg->HasFocus)
		{
			if (pPtr->spDlg->pOnLoseFocus)
				(*pPtr->spDlg->pOnLoseFocus)(pPtr->spDlg);
		}
	}
	pPtr = pPtr->spNext;
	}
}


CDXDlgMgr::~CDXDlgMgr(void)
{
CDXDlgMgrEntry* pPtr;
CDXDlgMgrEntry* pTemp;
pPtr = mpDlgHead;
while (pPtr != NULL)
	{
	fprintf(Logfile, "Deleting id = %u\n", pPtr->spDlg->Id);
	delete pPtr->spDlg;
	pTemp = pPtr->spNext;
	delete pPtr;
	pPtr = pTemp;
	}
}



void CDXDlgMgr::Redraw()
{

CDXDlgMgrEntry* pPtr;
int count =0;
pPtr = mpDlgHead;
mpSurface->Lock();
mpSurface->Rect(mDefaultRect.left,
				mDefaultRect.top,
				mDefaultRect.right,
				mDefaultRect.bottom,
				10);
mpSurface->UnLock();

while (pPtr != NULL)
	{
	if (pPtr->spDlg->Visible)
	{
		if (pPtr->spDlg->pOnRedraw != NULL)
		{
			(*pPtr->spDlg->pOnRedraw)(pPtr->spDlg, mpSurface);
		}
	}
	pPtr = pPtr->spNext;
	}
}


CDXDlgMgr::CDXDlgMgr(CDXSurface* pSurface, CDXInput* pInput)
{
	mpDlgHead = NULL;
	mpDlgTail = NULL;
	mDlgCount = 0;
	mpSurface = pSurface;
	mpInput = pInput;

	mMouse.x = 500;
	mMouse.y = 200;
	mCheckTriggers = true;
}

CDXDlgMgr::CDXDlgMgr(void)
{
	mpDlgHead = NULL;
	mpDlgTail = NULL;
	mDlgCount = 0;
	mMouse.x = 500;
	mMouse.y = 200;
	mCheckTriggers = true;
}

void CDXDlgMgr::Register(CDXDlg* pDlg)
{
CDXDlgMgrEntry* pPtr;
if (mpDlgHead == NULL)
	{
	mpDlgHead = new CDXDlgMgrEntry;
	mpDlgHead->spDlg = pDlg;
	mpDlgTail = mpDlgHead;
	mpDlgHead->spPrev = NULL;
	mpDlgHead->spNext = NULL;
	mpDlgHead->spDlg->Id = (int)mpDlgHead;
	mDlgCount++;
	fprintf(Logfile, "Register Id = %i\n", mpDlgHead->spDlg->Id);
	fflush(Logfile);
	}
else
	{
	pPtr = new CDXDlgMgrEntry;
	pPtr->spDlg = pDlg;
	pPtr->spPrev = NULL;
	pPtr->spNext = mpDlgHead;
	mpDlgHead = pPtr;
	mpDlgHead->spDlg->Id = (int)mpDlgHead;
	mDlgCount++;
	}
	fprintf(Logfile, "Register Id (else)= %i\n", mpDlgHead->spDlg->Id);
	fflush(Logfile);
}





void CDXDlgMgr::Destroy(CDXDlg* pDlg)
{
// destroy the entry

Trigger(pDlg, OnDestroy);
}




void CDXDlgMgr::Dump(void)
{
	CDXDlgMgrEntry* pDlgEntry;

	pDlgEntry = mpDlgHead;
	while (pDlgEntry != NULL)
	{
		printf("Id = %s\n", pDlgEntry->spDlg->Id);
	}

}


void CDXDlgMgr::UpdateMouse(void)
{
		mpInput->Update();
//		mMouse.x += mpInput->Mouse.x;
//		mMouse.y += mpInput->Mouse.y;
		mpInput->GetMousePos(&mMouse.x, &mMouse.y);
}




