#define CDXINCLUDEALL
#include "cdx.h"
#include <stdio.h>

//#include "cdx.h"

extern FILE* Logfile;

enum TriggerAction
	{	OnMouseOver,
		OnMouseDown,
		OnMouseUp,
		OnEnable,
		OnDisable,
		OnVisible,
		OnInvisible,
		OnRedraw,
		OnDestroy,
		OnGainFocus,
		OnLoseFocus
	};

enum DialogType
{
		BmpButton,
		PrimButton,
		HotSpot,
		Label
};


typedef struct DlgBmpButton
{
bool	Pressed;
CDXSurface*	UpBmp; // same size as DlgRect
CDXSurface*	DownBmp; // same size as DlgRect
CDXSurface* DisabledBmp;
bool		Selected;
} DlgBmpButton;


typedef struct DlgPrimButton
{
bool		Selected;
} DlgPrimButton;



typedef struct DlgHotSpot
{
CDXSurface *Bmp;
} DlgHotSpot;

typedef struct CDXDlg
{
// need common attributes for all types of Dlgs
// also need extra attributes for different types
// eg button and frame which contains changing text

	// define macro for FUNCTION as pointer to function
//	FUNCTION* pOnMouseOver;
//	FUNCTION* pOnMouseDown;
//	FUNCTION* pOnMouseUp;
//	FUNCTION* pOnEnable;
//	FUNCTION* pOnDisable;
//	FUNCTION* pOnVisible;
//	FUNCTION* pOnInvisible;
//	FUNCTION* pOnRedraw;
//	FUNCTION* pOnDestroy;

	void (*pOnMouseOver)(CDXDlg* pDlg, CDXInput* Input);
	void (*pOnMouseDown) (CDXDlg* pDlg, CDXInput* Input);
	void (*pOnMouseUp)(CDXDlg* pDlg, CDXInput* Input);
	void (*pOnRedraw)(CDXDlg* pDlg, CDXSurface* Surface);
	void (*pOnGainFocus)(CDXDlg* pDlg);
	void (*pOnLoseFocus)(CDXDlg* pDlg);
	void (*pOnDestroy)(CDXDlg* pDlg);
	void (*pOnCreate)(CDXDlg* pDlg);

	char*	Label;
	int		Id;
	char*	Title;
	bool	Enabled;
	RECT	DlgRect;
	RECT	ClientRect;
	bool	Visible;
	DialogType	DlgType;
	bool	Dirty;	// dirty=needs redrawing	
	int	BkColor;
	int	FgColor;
	bool	HasFocus;

	bool	LMWasPressed;
	bool	MMWasPressed;
	bool	RMWasPressed;

	union 
	{
		DlgBmpButton	BmpButton;
		DlgPrimButton	PrimButton;
		DlgHotSpot		HotSpot;
	};


} CDXDlg;


typedef struct CDXDlgMgrEntry
{
	CDXDlgMgrEntry*	spPrev;
	CDXDlg*		spDlg;
	CDXDlgMgrEntry*	spNext;
} CDXDlgMgrEntry;


class CDXDlgMgr
{
public:
	CDXDlgMgr(CDXSurface* pSurface, CDXInput* Input);
	CDXDlgMgr(void);
	~CDXDlgMgr(void);
	void Register(CDXDlg* pDlg);
	void Destroy(CDXDlg* pDlg);

	void Redraw(void);

	void UpdateMouse();
	BYTE CDXDlgMgr::LMBDown(void);
	BYTE CDXDlgMgr::RMBDown(void);

	void Trigger(void);
	void Trigger(CDXDlg* pDlg, TriggerAction Trigger);

	void Dump(void);
	POINT	mMouse;
	RECT	mDefaultRect;
	HWND	mhWnd;
	bool	mCheckTriggers;

private:
	CDXDlgMgrEntry*	Find(int Dlg);
	CDXDlgMgrEntry*	mpDlgHead;
	CDXDlgMgrEntry* mpDlgTail;
	int			mDlgCount;
	// coords of map window - if mouse cursor inside these coords
	// then dont bother with any triggers
	int			mx1,my1,mx2,my2;
	CDXSurface*		mpSurface;
	CDXInput*		mpInput;
};
