//////////////////////////////////////////////////////////////////////////////////
// $Source: /cvsroot/cdx/cdx3.0/src/cdx3d/frame.cpp,v $
// $Author: mindcry $
//
// $Log: frame.cpp,v $
// Revision 1.2  2000/08/24 19:15:30  mindcry
// Now uses the IDirect3DRM3 Interface. Thanks to Daniel Polli.
//
// Revision 1.1.1.1  2000/04/22 16:08:42  hebertjo
// Initial checkin of v3.0 to SourceForge CVS.
//
// Revision 2.0  1999/05/01 13:51:18  bsimser
// Updated revision number to 2.0
//
// Revision 1.1.1.1  1999/05/01 04:10:56  bsimser
// Initial revision to cvs
//
// $Revision: 1.2 $
//////////////////////////////////////////////////////////////////////////////////
#ifdef SAVE_RCSID
static char rcsid = "@(#) $Id: frame.cpp,v 1.2 2000/08/24 19:15:30 mindcry Exp $";
#endif

#include "CDX3D.h"

//////////////////////////////////////////////////////////////////////////////////
// CRMFrame Constructor
//////////////////////////////////////////////////////////////////////////////////
CRMFrame::CRMFrame(void)
{
	m_Frame = NULL;
}

//////////////////////////////////////////////////////////////////////////////////
// CRMFrame Constructor
//////////////////////////////////////////////////////////////////////////////////
CRMFrame::CRMFrame(CRMEngine* pEngine)
{
	m_Frame = NULL;
	m_Engine = pEngine;
}

//////////////////////////////////////////////////////////////////////////////////
// CRMFrame Destructor
//////////////////////////////////////////////////////////////////////////////////
CRMFrame::~CRMFrame(void)
{
	RELEASE(m_Frame);
}

//////////////////////////////////////////////////////////////////////////////////
// CRMFrame Create
//////////////////////////////////////////////////////////////////////////////////
BOOL CRMFrame::Create(CRMFrame* Parent)
{
	LPDIRECT3DRMFRAME3 frame1 = GetRef(Parent);
	LPDIRECT3DRMFRAME3 frame2;

	frame1->QueryInterface(IID_IDirect3DRMFrame2, (LPVOID*)&frame2);

	return m_Engine->CreateFrame(frame2, &m_Frame);
}

//////////////////////////////////////////////////////////////////////////////////
// CRMFrame AddChild
//////////////////////////////////////////////////////////////////////////////////
void CRMFrame::AddChild(CRMFrame* pChild)
{
	m_Frame->AddChild(pChild->m_Frame);
}

//////////////////////////////////////////////////////////////////////////////////
// CRMFrame AddLight
//////////////////////////////////////////////////////////////////////////////////
void CRMFrame::AddLight(CRMLight* pLight)
{
	m_Frame->AddLight(pLight->m_Light);
}

//////////////////////////////////////////////////////////////////////////////////
// CRMFrame GetRef
//////////////////////////////////////////////////////////////////////////////////
LPDIRECT3DRMFRAME3 CRMFrame::GetRef(CRMFrame* pRef)
{
	if(pRef) return pRef->m_Frame;
	else
	{
		if(!m_Frame) return NULL;

		LPDIRECT3DRMFRAME3 pParent = NULL;
		m_Frame->GetParent(&pParent);

		return pParent;
	}
}

//////////////////////////////////////////////////////////////////////////////////
// CRMFrame Move
//////////////////////////////////////////////////////////////////////////////////
HRESULT CRMFrame::Move(double delta)
{
	return m_Frame->Move(delta);
}

//////////////////////////////////////////////////////////////////////////////////
// CRMFrame SetDirection
//////////////////////////////////////////////////////////////////////////////////
void CRMFrame::SetDirection(double dx, double dy, double dz,
                            double ux, double uy, double uz, CRMFrame* pRef)
{
	m_Frame->SetOrientation(GetRef(pRef), D3DVAL(dx), D3DVAL(dy), D3DVAL(dz),
	                        D3DVAL(ux), D3DVAL(uy), D3DVAL(uz));
}

//////////////////////////////////////////////////////////////////////////////////
// CRMFrame SetDirection
//////////////////////////////////////////////////////////////////////////////////
void CRMFrame::GetDirection(double &dx, double &dy, double &dz,
                            double &ux, double &uy, double &uz, CRMFrame* pRef)
{
	D3DVECTOR dir;
	D3DVECTOR up;

	m_Frame->GetOrientation(GetRef(pRef), &dir, &up);

	dx = dir.x;
	dy = dir.y;
	dz = dir.z;
	ux = up.x;
	uy = up.y;
	uz = up.z;
}

//////////////////////////////////////////////////////////////////////////////////
// CRMFrame SetPosition
//////////////////////////////////////////////////////////////////////////////////
void CRMFrame::SetPosition(double x, double y, double z, CRMFrame* pRef)
{
	m_Frame->SetPosition(GetRef(pRef), D3DVAL(x), D3DVAL(y), D3DVAL(z));
}

//////////////////////////////////////////////////////////////////////////////////
// CRMFrame GetPosition
//////////////////////////////////////////////////////////////////////////////////
void CRMFrame::GetPosition(double &x, double &y, double &z, CRMFrame* pRef)
{
	D3DVECTOR v;

	m_Frame->GetPosition(GetRef(pRef), &v);

	x = v.x;
	y = v.y;
	z = v.z;
}

//////////////////////////////////////////////////////////////////////////////////
// CRMFrame SetRotation
//////////////////////////////////////////////////////////////////////////////////
void CRMFrame::SetRotation(double x, double y, double z, double t, CRMFrame* pRef)
{
	m_Frame->SetRotation(GetRef(pRef), D3DVAL(x), D3DVAL(y), D3DVAL(z), D3DVAL(t));
}

//////////////////////////////////////////////////////////////////////////////////
// CRMFrame GetRotation
//////////////////////////////////////////////////////////////////////////////////
void CRMFrame::GetRotation(double &x, double &y, double &z, float t, CRMFrame* pRef)
{
	D3DVECTOR v;

	m_Frame->GetRotation(GetRef(pRef), &v, &t);

	x = v.x;
	y = v.y;
	z = v.z;
}

//////////////////////////////////////////////////////////////////////////////////
// CRMFrame AddTransform
//////////////////////////////////////////////////////////////////////////////////
//HRESULT CRMFrame::AddTransform(CRMMatrix& m, D3DRMCOMBINETYPE ct)
//{
//	D3DRMMATRIX4D rlm;
//	m.Create(rlm);
//	return m_Frame->AddTransform(ct, rlm);
//}

//////////////////////////////////////////////////////////////////////////////////
// CRMFrame AddRotation
//////////////////////////////////////////////////////////////////////////////////
HRESULT CRMFrame::AddRotation(double x, double y, double z, double t, D3DRMCOMBINETYPE ct)
{
	return m_Frame->AddRotation(ct, D3DVAL(x), D3DVAL(y), D3DVAL(z), D3DVAL(t));
}
