//////////////////////////////////////////////////////////////////////////////////
// $Source: /cvsroot/cdx/cdx3.0/src/cdx3d/scene.cpp,v $
// $Author: hebertjo $
//
// $Log: scene.cpp,v $
// Revision 1.1.1.1  2000/04/22 16:08:42  hebertjo
// Initial checkin of v3.0 to SourceForge CVS.
//
// Revision 2.0  1999/05/01 13:51:18  bsimser
// Updated revision number to 2.0
//
// Revision 1.1.1.1  1999/05/01 04:10:56  bsimser
// Initial revision to cvs
//
// $Revision: 1.1.1.1 $
//////////////////////////////////////////////////////////////////////////////////
#ifdef SAVE_RCSID
static char rcsid = "@(#) $Id: scene.cpp,v 1.1.1.1 2000/04/22 16:08:42 hebertjo Exp $";
#endif

#include "CDX3D.h"

//////////////////////////////////////////////////////////////////////////////////
// CRMScene Constructor
//////////////////////////////////////////////////////////////////////////////////
CRMScene::CRMScene(CRMEngine* pEngine)
{
	m_Engine = pEngine;
	m_Light = NULL;
	m_Frame = NULL;
}

//////////////////////////////////////////////////////////////////////////////////
// CRMScene Destructor
//////////////////////////////////////////////////////////////////////////////////
CRMScene::~CRMScene(void)
{
	RELEASE(m_Light);
}

//////////////////////////////////////////////////////////////////////////////////
// CRMScene Create
//////////////////////////////////////////////////////////////////////////////////
BOOL CRMScene::Create(void)
{
	m_Engine->CreateFrame(NULL, &m_Frame);

	m_Engine->GetD3DRM()->CreateLightRGB(D3DRMLIGHT_AMBIENT, D3DVAL(0.3), D3DVAL(0.3), D3DVAL(0.3), &m_Light);
	m_Frame->AddLight(m_Light);

	return TRUE;
}

//////////////////////////////////////////////////////////////////////////////////
// CRMScene SetAmbientLight
//////////////////////////////////////////////////////////////////////////////////
HRESULT CRMScene::SetAmbientLight(double r, double g, double b)
{
	return m_Light->SetColorRGB(r, g, b);
}
