/////////////////////////////////////////////////////////////////////
// Project Name:   [ CDX Application Wizard - CDXAppWiz ]
// Source File:    [ CDXAppWizaw.cpp ]
// Author:         [ Michael Rich - istan@alltel.net ]
// Contributions:  [ Ioannis Karagiorgos, Bil Simser ]
// Revision:       [ 1.00 ]
/////////////////////////////////////////////////////////////////////


#include "stdafx.h"
#include "CDXAppWiz.h"
#include "CDXAppWizaw.h"
#include "chooser.h"

#ifdef _PSEUDO_DEBUG
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// This is called immediately after the custom AppWizard is loaded.  Initialize
//  the state of the custom AppWizard here.
void CCDXAppWizAppWiz::InitCustomAppWiz()
{
	// Create a new dialog chooser; CDialogChooser's constructor initializes
	//  its internal array with pointers to the steps.
	m_pChooser = new CDialogChooser;

	// Set the maximum number of steps.
	SetNumberOfSteps(LAST_DLG);

	// TODO: Add any other custom AppWizard-wide initialization here.
	
	// Setup all the default MACROS
	
	// #1
	m_Dictionary["PRJ_2D"]="Yes";
	m_Dictionary["COOP_FS"]="Yes";

	// #2
	m_Dictionary["WIDTH"] = "640";
	m_Dictionary["HEIGHT"] = "480";
	m_Dictionary["BPP"] = "8";
	m_Dictionary["8BIT"] = "Yes";

	// #3
	m_Dictionary["SPLASH"]="Yes";
	m_Dictionary["SPLASH8"]="Yes";
}

// This is called just before the custom AppWizard is unloaded.
void CCDXAppWizAppWiz::ExitCustomAppWiz()
{
	// Deallocate memory used for the dialog chooser
	ASSERT(m_pChooser != NULL);
	delete m_pChooser;
	m_pChooser = NULL;

	// TODO: Add code here to deallocate resources used by the custom AppWizard
}

// This is called when the user clicks "Create..." on the New Project dialog
//  or "Next" on one of the custom AppWizard's steps.
CAppWizStepDlg* CCDXAppWizAppWiz::Next(CAppWizStepDlg* pDlg)
{
	// Delegate to the dialog chooser
	return m_pChooser->Next(pDlg);
}

// This is called when the user clicks "Back" on one of the custom
//  AppWizard's steps.
CAppWizStepDlg* CCDXAppWizAppWiz::Back(CAppWizStepDlg* pDlg)
{
	// Delegate to the dialog chooser
	return m_pChooser->Back(pDlg);
}

#if _MSC_VER >= 1200
// For VC 6.0 and up
//#import "C:\Program Files\Microsoft Visual Studio\Common\MSDev98\Bin\IDE\devbld.pkg"
// Janni
#import "C:\Programme\Microsoft Visual Studio\Common\MSDev98\Bin\IDE\devbld.pkg"
#else
// For VC 5.0
#import "C:\Program Files\DevStudio\SharedIDE\Bin\IDE\devbld.pkg"
#endif
void CCDXAppWizAppWiz::CustomizeProject(IBuildProject* pProject)
{
	// TODO: Add code here to customize the project.  If you don't wish
	//  to customize project, you may remove this virtual override.
	

	using namespace DSProjectSystem;

	long lNumConfigs;
	IConfigurationsPtr pConfigs;
	IBuildProjectPtr pProj;
	// Needed to convert IBuildProject to the DSProjectSystem namespace
	pProj.Attach((DSProjectSystem::IBuildProject*)pProject, true);

	pProj->get_Configurations(&pConfigs);
	pConfigs->get_Count(&lNumConfigs);
	//Get each individual configuration
	for (long j = 1 ; j < lNumConfigs+1 ; j++)
	{
		_bstr_t varTool;
		_bstr_t varSwitch;
		IConfigurationPtr pConfig;
		_variant_t varj = j;

		pConfig = pConfigs->Item(varj);

		BSTR name;
		CString n;
		pConfig->get_Name(&name);
		n = name;

		// Remove Preprocessor def for MFC DLL specifier, _AFXDLL
		varTool   = "cl.exe";
		varSwitch = "/D \"_AFXDLL\"";
		pConfig->RemoveToolSettings(varTool, varSwitch, varj);

		varTool   = "rc.exe";
		varSwitch = "/d \"_AFXDLL\"";
		pConfig->RemoveToolSettings(varTool, varSwitch, varj);

		varTool   = "cl.exe";
		varSwitch = "/D \"STRICT\"";
		pConfig->AddToolSettings(varTool, varSwitch, varj);

		// OPTIONAL
		// Add Libs that MFC headers would have pulled in automatically
		// Feel free to customize this listing to your tastes
		varTool = "link.exe";
		// if they chose DX3 interfaces then use the proper CDX Libs
		if (m_Dictionary["DX3"].GetLength()>0)
		{
			// use the DX3 libs
			if (n.Find("Debug")>0)
			{
				if (m_Dictionary["PRJ_2D"].GetLength()>0)
					varSwitch = "ddraw.lib dsound.lib dxguid.lib dinput.lib winmm.lib cdxdx3d.lib";
				else
					varSwitch = "d3drm.lib ddraw.lib dsound.lib dxguid.lib dinput.lib winmm.lib cdxdx3d.lib cdx3ddx3d.lib";
			}
			else
			{
				if (m_Dictionary["PRJ_2D"].GetLength()>0)
					varSwitch = "ddraw.lib dsound.lib dxguid.lib dinput.lib winmm.lib cdxdx3.lib";
				else
					varSwitch = "d3drm.lib ddraw.lib dsound.lib dxguid.lib dinput.lib winmm.lib cdxdx3.lib cdx3ddx3.lib";
			}
		}
		else
		{
			// use the default libs
			if (n.Find("Debug")>0)
			{
				if (m_Dictionary["PRJ_2D"].GetLength()>0)
					varSwitch = "ddraw.lib dsound.lib dxguid.lib dinput.lib winmm.lib cdxd.lib";
				else
					varSwitch = "d3drm.lib ddraw.lib dsound.lib dxguid.lib dinput.lib winmm.lib cdxd.lib cdx3dd.lib";
			}
			else
			{
				if (m_Dictionary["PRJ_2D"].GetLength()>0)
					varSwitch = "ddraw.lib dsound.lib dxguid.lib dinput.lib winmm.lib cdx.lib";
				else
					varSwitch = "d3drm.lib ddraw.lib dsound.lib dxguid.lib dinput.lib winmm.lib cdx.lib cdx3d.lib";
			}
		}

		pConfig->AddToolSettings(varTool, varSwitch, varj);

#if _MSC_VER >= 1200
		// this is only valid for VC 6.0 and higher, VB5 GPFs with it
		varTool = "mfc";
		varSwitch = "0";
		pConfig->AddToolSettings(varTool, varSwitch, varj);
#endif
	}
}


// Here we define one instance of the CCDXAppWizAppWiz class.  You can access
//  m_Dictionary and any other public members of this class through the
//  global CDXAppWizaw.
CCDXAppWizAppWiz CDXAppWizaw;

