/////////////////////////////////////////////////////////////////////
// Project Name:   [ CDX Application Wizard - CDXAppWiz ]
// Source File:    [ Cstm1Dlg.cpp ]
// Author:         [ Michael Rich - istan@alltel.net ]
// Contributions:  [ Ioannis Karagiorgos, Bil Simser ]
// Revision:       [ 1.00 ]
/////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "CDXAppWiz.h"
#include "cstm1dlg.h"
#include "CDXAppWizaw.h"
#include "paint.h"

#ifdef _PSEUDO_DEBUG
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCustom1Dlg dialog


CCustom1Dlg::CCustom1Dlg()
	: CAppWizStepDlg(CCustom1Dlg::IDD)
{
	//{{AFX_DATA_INIT(CCustom1Dlg)
	m_nPrjDef = CCustom1Dlg::PRJ_2D;
	m_nCoopDef = CCustom1Dlg::COOP_FS;
	m_nInputDef = CCustom1Dlg::INPUT_KEYDOWN;
	m_nCoopStDef = CCustom1Dlg::COOP_START_FS;
	//}}AFX_DATA_INIT
}


void CCustom1Dlg::DoDataExchange(CDataExchange* pDX)
{
	CAppWizStepDlg::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCustom1Dlg)
	DDX_Radio(pDX, IDC_OPT_PRJ_2D, m_nPrjDef);
	DDX_Radio(pDX, IDC_OPT_COOP_FS, m_nCoopDef);
	DDX_Radio(pDX, IDC_OPT_COOP_START_FS, m_nCoopStDef);
	DDX_Radio(pDX, IDC_OPT_INPUT_KEYDOWN, m_nInputDef);
	
	//}}AFX_DATA_MAP
}

// This is called whenever the user presses Next, Back, or Finish with this step
//  present.  Do all validation & data exchange from the dialog in this function.
BOOL CCustom1Dlg::OnDismiss()
{
	CString strValue;

	if (!UpdateData(TRUE))
		return FALSE;

	// TODO: Set template variables based on the dialog's data.

	switch(m_nPrjDef)
	{
	case CCustom1Dlg::PRJ_2D:
		CDXAppWizaw.m_Dictionary["PRJ_2D"]="Yes";
		CDXAppWizaw.m_Dictionary.RemoveKey("PRJ_3D");
		break;
	case CCustom1Dlg::PRJ_3D:
		CDXAppWizaw.m_Dictionary["PRJ_3D"]="Yes";
		CDXAppWizaw.m_Dictionary.RemoveKey("PRJ_2D");
		break;
	}

	switch(m_nCoopDef)
	{
	case CCustom1Dlg::COOP_FS:
		CDXAppWizaw.m_Dictionary["COOP_FS"]="Yes";
		CDXAppWizaw.m_Dictionary.RemoveKey("COOP_WIN");
		CDXAppWizaw.m_Dictionary.RemoveKey("COOP_BOTH");
		break;
	case CCustom1Dlg::COOP_WIN:
		CDXAppWizaw.m_Dictionary["COOP_WIN"]="Yes";
		CDXAppWizaw.m_Dictionary.RemoveKey("COOP_FS");
		CDXAppWizaw.m_Dictionary.RemoveKey("COOP_BOTH");
		break;
	case CCustom1Dlg::COOP_BOTH:
		CDXAppWizaw.m_Dictionary["COOP_BOTH"]="Yes";
		CDXAppWizaw.m_Dictionary.RemoveKey("COOP_WIN");
		CDXAppWizaw.m_Dictionary.RemoveKey("COOP_FS");

		switch(m_nCoopStDef)
		{
		case CCustom1Dlg::COOP_START_FS:
			CDXAppWizaw.m_Dictionary["COOP_ST_FS"]="Yes";
			CDXAppWizaw.m_Dictionary.RemoveKey("COOP_ST_WIN");
			break;
		case CCustom1Dlg::COOP_START_WIN:
			CDXAppWizaw.m_Dictionary["COOP_ST_WIN"]="Yes";
			CDXAppWizaw.m_Dictionary.RemoveKey("COOP_ST_FS");
			break;
		}

		break;
	}

	if (m_nCoopDef!=CCustom1Dlg::COOP_BOTH)
	{
		CDXAppWizaw.m_Dictionary.RemoveKey("COOP_ST_FS");
		CDXAppWizaw.m_Dictionary.RemoveKey("COOP_ST_WIN");
	}

	switch(m_nInputDef)
	{
	case CCustom1Dlg::INPUT_KEYDOWN:
		CDXAppWizaw.m_Dictionary["INPUT_KEYDOWN"]="Yes";
		CDXAppWizaw.m_Dictionary.RemoveKey("INPUT_CDXINPUT");
		break;
	case CCustom1Dlg::INPUT_CDXINPUT:
		CDXAppWizaw.m_Dictionary["INPUT_CDXINPUT"]="Yes";
		CDXAppWizaw.m_Dictionary.RemoveKey("INPUT_KEYDOWN");
		break;
	}

	return TRUE;	// return FALSE if the dialog shouldn't be dismissed
}


BEGIN_MESSAGE_MAP(CCustom1Dlg, CAppWizStepDlg)
	//{{AFX_MSG_MAP(CCustom1Dlg)
	ON_COMMAND_EX(IDC_OPT_COOP_FS, OnClickedRadio)
	ON_COMMAND_EX(IDC_OPT_COOP_WIN, OnClickedRadio)
	ON_COMMAND_EX(IDC_OPT_COOP_BOTH, OnClickedRadio)
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CCustom1Dlg message handlers

#define STEP1_LEFT            8
#define STEP1_TOP             40
#define STEP1_WIDTH           179
#define STEP1_HEIGHT          180

void CCustom1Dlg::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	
	PaintBackground(&dc, this);

	CDC dcMem;
	if (!dcMem.CreateCompatibleDC(&dc))
		return;

	// picture
	PaintBitmap(IDB_STEP_1, STEP1_LEFT, STEP1_TOP, STEP1_WIDTH, STEP1_HEIGHT, &dc, &dcMem);
}

BOOL CCustom1Dlg::OnClickedRadio(UINT nID)
{
	UpdateData(TRUE);

	GetDlgItem(IDC_OPT_COOP_START_FS)->EnableWindow((BOOL)(m_nCoopDef == CCustom1Dlg::COOP_BOTH));
	GetDlgItem(IDC_OPT_COOP_START_WIN)->EnableWindow((BOOL)(m_nCoopDef == CCustom1Dlg::COOP_BOTH));

	return TRUE;
}
