/////////////////////////////////////////////////////////////////////
// Project Name:   [ CDX Application Wizard - CDXAppWiz ]
// Source File:    [ Cstm2Dlg.cpp ]
// Author:         [ Michael Rich - istan@alltel.net ]
// Contributions:  [ Ioannis Karagiorgos, Bil Simser ]
// Revision:       [ 1.00 ]
/////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "CDXAppWiz.h"
#include "cstm2dlg.h"
#include "CDXAppWizaw.h"
#include "paint.h"

#ifdef _PSEUDO_DEBUG
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCustom2Dlg dialog


CCustom2Dlg::CCustom2Dlg()
	: CAppWizStepDlg(CCustom2Dlg::IDD)
{
	//{{AFX_DATA_INIT(CCustom2Dlg)
	m_bDX3 = FALSE;
	m_nWidth = 640;
	m_nHeight = 480;
	m_nBPP = 8;
	m_strName = "";
	m_bHandle3216 = TRUE;
	m_nMouseDef = CCustom2Dlg::MOUSE_OFFYES;
	//}}AFX_DATA_INIT
}


void CCustom2Dlg::DoDataExchange(CDataExchange* pDX)
{
	CAppWizStepDlg::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCustom2Dlg)
	DDX_Check(pDX, IDC_CHK_DX3, m_bDX3);
	DDX_Text(pDX, IDC_TXT_WIDTH, m_nWidth);
	DDV_MinMaxInt(pDX, m_nWidth, 320, 1600);
	DDX_Text(pDX, IDC_TXT_HEIGHT, m_nHeight);
	DDV_MinMaxInt(pDX, m_nHeight, 240, 1600);
	DDX_Text(pDX, IDC_TXT_BPP, m_nBPP);
	DDV_MinMaxInt(pDX, m_nBPP, 8, 32);
	DDX_Text(pDX, IDC_TXT_NAME, m_strName);
	DDX_Radio(pDX, IDC_OPT_MOUSE_OFFYES, m_nMouseDef);
	DDX_Check(pDX, IDC_CHK_HANDLE3216, m_bHandle3216);
	//}}AFX_DATA_MAP
}

// This is called whenever the user presses Next, Back, or Finish with this step
//  present.  Do all validation & data exchange from the dialog in this function.
BOOL CCustom2Dlg::OnDismiss()
{
	CString strValue;

	if (!UpdateData(TRUE))
		return FALSE;

	// TODO: Set template variables based on the dialog's data.
	if (m_bDX3)
		CDXAppWizaw.m_Dictionary["DX3"]="Yes";
	else
		CDXAppWizaw.m_Dictionary.RemoveKey("DX3");

	if (m_strName.GetLength()==0)
		m_strName = CDXAppWizaw.m_Dictionary["Root"];

	CDXAppWizaw.m_Dictionary["APP_TITLE"] = m_strName;

	strValue.Format(_T("%d"), m_nWidth);
	CDXAppWizaw.m_Dictionary["WIDTH"] = strValue;

	strValue.Format(_T("%d"), m_nHeight);
	CDXAppWizaw.m_Dictionary["HEIGHT"] = strValue;

	strValue.Format(_T("%d"), m_nBPP);
	CDXAppWizaw.m_Dictionary["BPP"] = strValue;

	// remove the well known keys first
	CDXAppWizaw.m_Dictionary.RemoveKey("8BIT");
	CDXAppWizaw.m_Dictionary.RemoveKey("15BIT");
	CDXAppWizaw.m_Dictionary.RemoveKey("16BIT");
	CDXAppWizaw.m_Dictionary.RemoveKey("24BIT");
	CDXAppWizaw.m_Dictionary.RemoveKey("32BIT");

	// create the value for the mode	
	strValue.Format(_T("%dBIT"), m_nBPP);
	CDXAppWizaw.m_Dictionary[strValue] = strValue;

	// only let them enable the handle 32/16 if they are going to use
	// a mode > 8-bit
	if (m_bHandle3216 && m_nBPP > 8)
		CDXAppWizaw.m_Dictionary["HANDLE_3216"]="Yes";
	else
		CDXAppWizaw.m_Dictionary.RemoveKey("HANDLE_3216");
	
	switch(m_nMouseDef)
	{
	case CCustom2Dlg::MOUSE_OFFYES:
		CDXAppWizaw.m_Dictionary["MOUSEON"] = "Yes";
		break;
	case CCustom2Dlg::MOUSE_OFFNO:
		CDXAppWizaw.m_Dictionary.RemoveKey("MOUSEON");
		break;
	}
	return TRUE;	// return FALSE if the dialog shouldn't be dismissed
}

BOOL CCustom2Dlg::OnInitDialog()
{
	// if 3d proj, then default to 16-bit mode
	if (CDXAppWizaw.m_Dictionary["PRJ_3D"]=="Yes")
		m_nBPP = 16;
	else
		m_nBPP = 8;

	// refresh the option values
	UpdateData(FALSE);

	return TRUE;
}

BEGIN_MESSAGE_MAP(CCustom2Dlg, CAppWizStepDlg)
	//{{AFX_MSG_MAP(CCustom2Dlg)
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CCustom2Dlg message handlers

#define STEP2_LEFT            8
#define STEP2_TOP             40
#define STEP2_WIDTH           179
#define STEP2_HEIGHT          180

void CCustom2Dlg::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	
	PaintBackground(&dc, this);

	CDC dcMem;
	if (!dcMem.CreateCompatibleDC(&dc))
		return;

	// picture
	PaintBitmap(IDB_STEP_1, STEP2_LEFT, STEP2_TOP, STEP2_WIDTH, STEP2_HEIGHT, &dc, &dcMem);
}

void CCustom2Dlg::DelayedInit()
{
	m_strName = CDXAppWizaw.m_Dictionary["Root"];
}
