/////////////////////////////////////////////////////////////////////
// Project Name:   [ CDX Application Wizard 3.0 - CDXAppWiz ]
// Source File:    [ Chooser.cpp ]
// Author:         [ Michael Rich - mike@alphax86.com ]
// Contributions:  [ Ioannis Karagiorgos, Bil Simser ]
// Revision:       [ 1.00 ]
/////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "CDXAppWiz.h"
#include "chooser.h"
#include "cstm1dlg.h"
#include "cstm2dlg.h"
#include "cstm3dlg.h"
#include "CDXAppWizaw.h"

#ifdef _PSEUDO_DEBUG
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// On construction, set up internal array with pointers to each step.
CDialogChooser::CDialogChooser()
{
	m_pDlgs[0] = NULL;

	m_pDlgs[1] = new CCustom1Dlg;
	m_pDlgs[2] = new CCustom2Dlg;
	m_pDlgs[3] = new CCustom3Dlg;

	m_nCurrDlg = 0;
}
// Remember where the custom steps begin, so we can delete them in
//  the destructor
#define FIRST_CUSTOM_STEP 1
#define LAST_CUSTOM_STEP 3

// The destructor deletes entries in the internal array corresponding to
//  custom steps.
CDialogChooser::~CDialogChooser()
{
	for (int i = FIRST_CUSTOM_STEP; i <= LAST_CUSTOM_STEP; i++)
	{
		ASSERT(m_pDlgs[i] != NULL);
		delete m_pDlgs[i];
	}
}

// Use the internal array to determine the next step.
CAppWizStepDlg* CDialogChooser::Next(CAppWizStepDlg* pDlg)
{
	ASSERT(0 <= m_nCurrDlg && m_nCurrDlg < LAST_DLG);
	ASSERT(pDlg == m_pDlgs[m_nCurrDlg]);

	if (m_nCurrDlg == 0)
	{
		CCustom2Dlg *d = (CCustom2Dlg*)m_pDlgs[2];
		d->DelayedInit();
	}

	m_nCurrDlg++;
	return m_pDlgs[m_nCurrDlg];
}

// Use the internal array to determine the previous step.
CAppWizStepDlg* CDialogChooser::Back(CAppWizStepDlg* pDlg)
{
	ASSERT(1 <= m_nCurrDlg && m_nCurrDlg <= LAST_DLG);
	ASSERT(pDlg == m_pDlgs[m_nCurrDlg]);

	m_nCurrDlg--;
	return m_pDlgs[m_nCurrDlg];
}

void CDialogChooser::UpdateTitleIfNecessary()
{
	((CAppWizStepDlg*) m_pDlgs[FIRST_CUSTOM_STEP])->SetWindowText("Test");	
//	MessageBox(NULL, CDXAppWizaw.m_Dictionary["Root"], "", 0);
}
