/////////////////////////////////////////////////////////////////////
// Project Name:   [ CDX Application Wizard 3.0 - CDXAppWiz ]
// Source File:    [ Chooser.h ]
// Author:         [ Michael Rich - mike@alphax86.com ]
// Contributions:  [ Ioannis Karagiorgos, Bil Simser ]
// Revision:       [ 1.00 ]
/////////////////////////////////////////////////////////////////////

#if !defined(AFX_CHOOSER_H__711A690C_065E_11D3_B6B9_00C0F022FA47__INCLUDED_)
#define AFX_CHOOSER_H__711A690C_065E_11D3_B6B9_00C0F022FA47__INCLUDED_

// chooser.h : declaration of the CDialogChooser class
//             This class keeps track of what dialogs to pop up when.

#define LAST_DLG 3

class CDialogChooser
{
public:
	CDialogChooser();
	~CDialogChooser();

	// All calls by mfcapwz.dll to CCDXAppWizAppWiz::Next
	//  & CCDXAppWizAppWiz::Back are delegated to these member
	//  functions, which keep track of what dialog is up
	//  now, and what to pop up next.
	CAppWizStepDlg* Next(CAppWizStepDlg* pDlg);
	CAppWizStepDlg* Back(CAppWizStepDlg* pDlg);

protected:
	// Current step's index into the internal array m_pDlgs
	int m_nCurrDlg;

	// Internal array of pointers to the steps
	CAppWizStepDlg* m_pDlgs[LAST_DLG + 1];
	void UpdateTitleIfNecessary();
};


//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_CHOOSER_H__711A690C_065E_11D3_B6B9_00C0F022FA47__INCLUDED_)
