/////////////////////////////////////////////////////////////////////
// Project Name:   [ CDX Application Wizard 3.0 - CDXAppWiz ]
// Source File:    [ Cstm3Dlg.cpp ]
// Author:         [ Michael Rich - mike@alphax86.com ]
// Contributions:  [ Ioannis Karagiorgos, Bil Simser ]
// Revision:       [ 1.00 ]
/////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "CDXAppWiz.h"
#include "cstm3dlg.h"
#include "CDXAppWizaw.h"
#include "paint.h"

#ifdef _PSEUDO_DEBUG
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCustom3Dlg dialog


CCustom3Dlg::CCustom3Dlg()
	: CAppWizStepDlg(CCustom3Dlg::IDD)
{
	//{{AFX_DATA_INIT(CCustom3Dlg)
	m_bSplash = TRUE;
	m_bTripleBuff = FALSE;
	m_bLooseFocus = FALSE;
	m_bCngExeDir = FALSE;
	m_b3DScene = TRUE;
	m_bCenterWindow = FALSE;
	//}}AFX_DATA_INIT
}


void CCustom3Dlg::DoDataExchange(CDataExchange* pDX)
{
	CAppWizStepDlg::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCustom3Dlg)
	DDX_Check(pDX, IDC_CHK_SPLASH, m_bSplash);
	DDX_Check(pDX, IDC_CHK_TRIPBUFF, m_bTripleBuff);
	DDX_Check(pDX, IDC_CHK_LOOSEFOCUS, m_bLooseFocus);
	DDX_Check(pDX, IDC_CHK_EXEDIR, m_bCngExeDir);
	DDX_Check(pDX, IDC_CHK_3DSCENE, m_b3DScene);
	DDX_Check(pDX, IDC_CHK_CENTERWINDOW, m_bCenterWindow);
	//}}AFX_DATA_MAP
}

// This is called whenever the user presses Next, Back, or Finish with this step
//  present.  Do all validation & data exchange from the dialog in this function.
BOOL CCustom3Dlg::OnDismiss()
{
	if (!UpdateData(TRUE))
		return FALSE;

	if (m_bSplash && CDXAppWizaw.m_Dictionary["PRJ_2D"]=="Yes")
	{
		int bpp;

		CDXAppWizaw.m_Dictionary["SPLASH"]="Yes";
		bpp = atoi(CDXAppWizaw.m_Dictionary["BPP"]);
		if (bpp == 16)
		{
			CDXAppWizaw.m_Dictionary["SPLASH16"]="Yes";
			CDXAppWizaw.m_Dictionary.RemoveKey("SPLASH24");
			CDXAppWizaw.m_Dictionary.RemoveKey("SPLASH8");
		}
		else if (bpp == 24)
		{
			CDXAppWizaw.m_Dictionary["SPLASH24"]="Yes";
			CDXAppWizaw.m_Dictionary.RemoveKey("SPLASH16");
			CDXAppWizaw.m_Dictionary.RemoveKey("SPLASH8");
		}
		else
		{
			CDXAppWizaw.m_Dictionary["SPLASH8"]="Yes";
			CDXAppWizaw.m_Dictionary.RemoveKey("SPLASH16");
			CDXAppWizaw.m_Dictionary.RemoveKey("SPLASH24");
		}
	}
	else
	{
		CDXAppWizaw.m_Dictionary.RemoveKey("SPLASH");
		CDXAppWizaw.m_Dictionary.RemoveKey("SPLASH16");
		CDXAppWizaw.m_Dictionary.RemoveKey("SPLASH24");
		CDXAppWizaw.m_Dictionary.RemoveKey("SPLASH8");
	}

	if (m_bTripleBuff)
		CDXAppWizaw.m_Dictionary["TRIPLEBUFF"]="Yes";
	else
		CDXAppWizaw.m_Dictionary.RemoveKey("TRIPLEBUFF");

	if (m_bLooseFocus)
		CDXAppWizaw.m_Dictionary["LOOSEFOCUS"]="Yes";
	else
		CDXAppWizaw.m_Dictionary.RemoveKey("LOOSEFOCUS");

	if (m_bCngExeDir)
		CDXAppWizaw.m_Dictionary["CHGEXEDIR"]="Yes";
	else
		CDXAppWizaw.m_Dictionary.RemoveKey("CHGEXEDIR");

	if (m_bCenterWindow)
		CDXAppWizaw.m_Dictionary["CENTERWINDOW"]="Yes";
	else
		CDXAppWizaw.m_Dictionary.RemoveKey("CENTERWINDOW");
	
	if (m_b3DScene && CDXAppWizaw.m_Dictionary["PRJ_3D"]=="Yes")
		CDXAppWizaw.m_Dictionary["ROTSQ"]="Yes";
	else
		CDXAppWizaw.m_Dictionary.RemoveKey("ROTSQ");

	return TRUE;	// return FALSE if the dialog shouldn't be dismissed
}

BOOL CCustom3Dlg::OnInitDialog()
{
//	MessageBox("OnInitDialog");

	GetDlgItem(IDC_CHK_3DSCENE)->EnableWindow((BOOL)(CDXAppWizaw.m_Dictionary["PRJ_3D"]=="Yes"));
	GetDlgItem(IDC_CHK_SPLASH)->EnableWindow((BOOL)(CDXAppWizaw.m_Dictionary["PRJ_2D"]=="Yes"));

	// refresh the option values
	UpdateData(FALSE);

	return TRUE;
}

BEGIN_MESSAGE_MAP(CCustom3Dlg, CAppWizStepDlg)
	//{{AFX_MSG_MAP(CCustom3Dlg)
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CCustom3Dlg message handlers

#define STEP3_LEFT            8
#define STEP3_TOP             40
#define STEP3_WIDTH           179
#define STEP3_HEIGHT          180

void CCustom3Dlg::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	
	PaintBackground(&dc, this);

	CDC dcMem;
	if (!dcMem.CreateCompatibleDC(&dc))
		return;

	// picture
	PaintBitmap(IDB_STEP_1, STEP3_LEFT, STEP3_TOP, STEP3_WIDTH, STEP3_HEIGHT, &dc, &dcMem);
}
