// CDXCreatorDlg.cpp : Implementierungsdatei
//

#include "stdafx.h"
#include "CDXCreator.h"
#include "CDXCreatorDlg.h"



#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

int filecreated=0;

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg-Dialogfeld fr Anwendungsbefehl "Info"

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialogfelddaten
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// Vom Klassenassistenten generierte berladungen virtueller Funktionen
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV-Untersttzung
	//}}AFX_VIRTUAL

// Implementierung
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// Keine Nachrichten-Handler
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCDXCreatorDlg Dialogfeld

CCDXCreatorDlg::CCDXCreatorDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCDXCreatorDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CCDXCreatorDlg)
	m_AppName = _T("");
	m_SeeCompo = _T("");
	m_SeeFont = _T("");
	m_SeeMusic = _T("");
	m_SeeVideo = _T("");
	m_SeeVMode = _T("");
	//}}AFX_DATA_INIT
	// Beachten Sie, dass LoadIcon unter Win32 keinen nachfolgenden DestroyIcon-Aufruf bentigt
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CCDXCreatorDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCDXCreatorDlg)
	DDX_Text(pDX, IDC_NAME_EDIT, m_AppName);
	DDX_Text(pDX, IDC_SEE_COMPO_EDIT, m_SeeCompo);
	DDX_Text(pDX, IDC_SEE_FONT_EDIT, m_SeeFont);
	DDX_Text(pDX, IDC_SEE_MUSIC_EDIT, m_SeeMusic);
	DDX_Text(pDX, IDC_SEE_VIDEO_EDIT, m_SeeVideo);
	DDX_Text(pDX, IDC_SEE_VMODE_EDIT, m_SeeVMode);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CCDXCreatorDlg, CDialog)
	//{{AFX_MSG_MAP(CCDXCreatorDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_EXIT_BUTTON, OnExitButton)
	ON_BN_CLICKED(IDC_CREATE_BUTTON, OnCreateButton)
	ON_EN_CHANGE(IDC_NAME_EDIT, OnChangeNameEdit)
	ON_BN_CLICKED(IDC_ADDVIDEO_BUTTON, OnAddvideoButton)
	ON_BN_CLICKED(IDC_ADDMUSIC_BUTTON, OnAddmusicButton)
	ON_BN_CLICKED(IDC_LOADFONT_BUTTON, OnLoadfontButton)
	ON_BN_CLICKED(IDC_VIDEOMODES_BUTTON, OnVideomodesButton)
	ON_BN_CLICKED(IDC_COMPONENTS_BUTTON, OnComponentsButton)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCDXCreatorDlg Nachrichten-Handler

BOOL CCDXCreatorDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Hinzufgen des Menbefehls "Info..." zum Systemmen.

	// IDM_ABOUTBOX muss sich im Bereich der Systembefehle befinden.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Symbol fr dieses Dialogfeld festlegen. Wird automatisch erledigt
	//  wenn das Hauptfenster der Anwendung kein Dialogfeld ist
	SetIcon(m_hIcon, TRUE);			// Groes Symbol verwenden
	SetIcon(m_hIcon, FALSE);		// Kleines Symbol verwenden
	
	// ZU ERLEDIGEN: Hier zustzliche Initialisierung einfgen
	
//	m_Input=TRUE;
//	m_800=TRUE;
//	m_16Bit=TRUE;
	
	UpdateData (FALSE);

	return TRUE;  // Geben Sie TRUE zurck, auer ein Steuerelement soll den Fokus erhalten
}

void CCDXCreatorDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// Wollen Sie Ihrem Dialogfeld eine Schaltflche "Minimieren" hinzufgen, bentigen Sie 
//  den nachstehenden Code, um das Symbol zu zeichnen. Fr MFC-Anwendungen, die das 
//  Dokument/Ansicht-Modell verwenden, wird dies automatisch fr Sie erledigt.

void CCDXCreatorDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // Gertekontext fr Zeichnen

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Symbol in Client-Rechteck zentrieren
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Symbol zeichnen
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// Die Systemaufrufe fragen den Cursorform ab, die angezeigt werden soll, whrend der Benutzer
//  das zum Symbol verkleinerte Fenster mit der Maus zieht.
HCURSOR CCDXCreatorDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CCDXCreatorDlg::OnExitButton() 
{
	int result;
	if (filecreated==0)
	{
		result=MessageBox ("Warning! Youve not saved your application yet!\nDo you really want to quit?","Question",MB_OKCANCEL+MB_ICONWARNING);
		if (result==IDOK) OnOK ();
	}
	else
	{
		result=MessageBox ("Really quit?","Question",MB_OKCANCEL+MB_ICONQUESTION);
		if (result==IDOK) OnOK ();
	}
}

void CCDXCreatorDlg::OnCreateButton() 
{
	FILE *Fh;
	filecreated=1;
	int Comments=0;

	if (m_AppName!="")
	{
		int result=MessageBox ("Would you like to see comments in the SourceCode?","CDXCreator",MB_YESNO+MB_ICONQUESTION);
		if (result==IDYES) Comments=1;
		else Comments=0;
		
		if( (Fh = fopen( m_AppName+".cpp", "w" )) != NULL )
		{
			fprintf (Fh, "// This file was made with the CDXCreator 1.1b by Andreas Lffler.\n");
			fprintf (Fh, "// For updates or questions visit the CDX-Website at: http://www.cdx.sk\n\n");
			fprintf (Fh, "// You must link this program with: cdx.lib ddraw.lib dxguid.lib dinput.lib winmm.lib\n// Have fun!\n\n");

			fprintf (Fh, "#include <windows.h>\n");
			fprintf (Fh, "#include <windowsx.h>\n");
			fprintf (Fh, "#include <stdlib.h>\n");
			fprintf (Fh, "#include <stdio.h>\n");
			fprintf (Fh, "#include <time.h>\n");
			fprintf (Fh, "#include <CDX.h>\n\n\n");

			if (Comments==1) fprintf (Fh, "// The Screen-Object.\n");
			fprintf (Fh, "CDXScreen* Screen;\n");
						
			if (components_dlg.m_Input==TRUE)
			{
				fprintf (Fh, "\n");
				if (Comments==1) fprintf (Fh, "// Here has CDXCreator created the Input-Handle.\n");
				fprintf (Fh, "CDXInput Input;\n");
			}

			if (components_dlg.m_Sound==TRUE)
			{
				fprintf (Fh, "\n");
				if (Comments==1) fprintf (Fh, "// And heres the Sound-System!\n");
				fprintf (Fh, "CDXSound* Sound;\n");
			}

			if (components_dlg.m_Music==TRUE || music_dlg.m_AddMusic!="")
			{
				fprintf (Fh, "\n");
				if (Comments==1) fprintf (Fh, "// The Music-System!\n");
				fprintf (Fh, "CDXMusic* Music;\n");
			}

			if (video_dlg.m_AddVideo!="")
			{
				fprintf (Fh, "\n");
				if (Comments==1) fprintf (Fh, "// This is the Intro-File you want, isnt it?\n");
				fprintf (Fh, "CDXAvi*   IntroVideo;\n");
				fprintf (Fh, "CDXSound* IntroSound;\n");
 			}

			fprintf (Fh, "\n");
			if (Comments==1) fprintf (Fh, "// Is the program running?\n");
			fprintf (Fh, "BOOL bActive;\n");

			fprintf (Fh, "\nlong PASCAL WinProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)\n");
			fprintf (Fh, "{\n");
			fprintf (Fh, "		switch(message)\n");
			fprintf (Fh, "		{\n");
			fprintf (Fh, "			case WM_ACTIVATEAPP:\n");
	        fprintf (Fh, "				 bActive = wParam;\n");
			fprintf (Fh, "				 break;\n\n");
			fprintf (Fh, "			case WM_KEYDOWN:\n");
			fprintf (Fh, "				 switch(wParam)\n");
			fprintf (Fh, "				 {\n");
			fprintf (Fh, "					 case VK_ESCAPE:\n");
			fprintf (Fh, "			 	     PostMessage(hWnd, WM_CLOSE, 0, 0);\n");
			fprintf (Fh, "		  			 break;\n");
			fprintf (Fh, "				 }\n");
			fprintf (Fh, "			  	 break;\n\n");
			fprintf (Fh, "			case WM_DESTROY:\n");
			fprintf (Fh, "				PostQuitMessage(0);\n");
			fprintf (Fh, "				break;\n\n");
			fprintf (Fh, "		}\n");
			fprintf (Fh, "		return DefWindowProc(hWnd, message, wParam, lParam);\n");
			fprintf (Fh, "}\n\n");

			fprintf (Fh, "BOOL InitApp(HINSTANCE hInst, int nCmdShow)\n");
			fprintf (Fh, "{\n");
			fprintf (Fh, "		HWND hWnd;\n");
			fprintf (Fh, "		WNDCLASS WndClass;\n");
			fprintf (Fh, "		WndClass.style = CS_DBLCLKS;\n");
			fprintf (Fh, "		WndClass.lpfnWndProc = WinProc;\n");
			fprintf (Fh, "		WndClass.cbClsExtra = 0;\n");
			fprintf (Fh, "		WndClass.cbWndExtra = 0;\n");
			fprintf (Fh, "		WndClass.hInstance = hInst;\n");
			fprintf (Fh, "		WndClass.hIcon = LoadIcon(hInst, IDI_APPLICATION);\n");
			fprintf (Fh, "		WndClass.hCursor = LoadCursor(NULL, IDC_ARROW);\n");
			fprintf (Fh, "		WndClass.hbrBackground = GetStockObject(BLACK_BRUSH);\n");
			fprintf (Fh, "		WndClass.lpszMenuName = 0;\n");
			fprintf (Fh, "		WndClass.lpszClassName = \""+ m_AppName+"\";\n");
			fprintf (Fh, "		RegisterClass(&WndClass);\n\n");

			fprintf (Fh, "		hWnd = CreateWindowEx(\n");
			fprintf (Fh, "		WS_EX_TOPMOST,\n");
			fprintf (Fh, "	    \""+m_AppName+"\",\n");
			fprintf (Fh, "	    \""+m_AppName+"\",\n");
			fprintf (Fh, "		WS_POPUP,\n");
			fprintf (Fh, "		0,0,\n");
			fprintf (Fh, "		GetSystemMetrics(SM_CXSCREEN),\n");
			fprintf (Fh, "		GetSystemMetrics(SM_CYSCREEN),\n");
			fprintf (Fh, "		NULL,\n");
			fprintf (Fh, "		NULL,\n");
			fprintf (Fh, "		hInst,\n");
			fprintf (Fh, "		NULL);\n\n");
			fprintf (Fh, "		if(!hWnd) return FALSE;\n\n");

			fprintf (Fh, "		ShowWindow(hWnd, nCmdShow);\n");
			fprintf (Fh, "		UpdateWindow(hWnd);\n\n");

  	        fprintf (Fh, "		Screen = new CDXScreen();\n");
			
			if (vmode_dlg.m_320==TRUE)  fprintf (Fh, "      Screen->CreateFullScreen(hWnd, 320, 200, 8);\n");
			if (vmode_dlg.m_640==TRUE)  fprintf (Fh, "		Screen->CreateFullScreen(hWnd, 640, 480");
			if (vmode_dlg.m_800==TRUE)  fprintf (Fh, "		Screen->CreateFullScreen(hWnd, 800, 600");
			if (vmode_dlg.m_1024==TRUE) fprintf (Fh, "		Screen->CreateFullScreen(hWnd, 1024, 768");
			if (vmode_dlg.m_16Bit==TRUE) fprintf (Fh, ", 16);\n");
			if (vmode_dlg.m_24Bit==TRUE) fprintf (Fh, ", 24);\n");
			if (vmode_dlg.m_32Bit==TRUE) fprintf (Fh, ", 32);\n");


			fprintf (Fh, "		Screen->Fill(0);\n\n");
			if (components_dlg.m_Input==TRUE) fprintf (Fh, "		Input.Create(hInst, hWnd);\n");
		    fprintf (Fh, "\n");
			
			if (video_dlg.m_AddVideo!="")
			{
			  if (Comments==1) fprintf (Fh, "		// The initializing-stuff for the Intro-Video.\n");
			    fprintf (Fh, "		IntroSound = new CDXSound;\n");
				fprintf (Fh, "		IntroSound->Create(hWnd);\n");
 				fprintf (Fh, "		IntroVideo = new CDXAvi();\n");
				fprintf (Fh, "		IntroVideo ->Create(Screen,IntroSound,");
				fprintf (Fh, "\"" +video_dlg.m_AddVideo+"\", ");
				if (video_dlg.m_LoopVideo==TRUE) fprintf (Fh, "TRUE);\n");
				else fprintf (Fh, "FALSE);\n");
				fprintf (Fh, "		IntroVideo ->Start();\n\n");
			}

			if (font_dlg.m_LoadDefaultFont==TRUE) fprintf (Fh, "		Screen->GetBack()->ChangeFont(\"Stop\",10,25,FW_BOLD);\n");
			if (font_dlg.m_Font!="")
			{
				fprintf (Fh, "		Screen->GetBack()->ChangeFont(\""+font_dlg.m_Font+"\",10,25,FW_BOLD);\n");
			}


			fprintf (Fh, "\n");

			if (Comments==1)
			{
				fprintf (Fh, "		// Here you can add instructions for your game/application!\n");
				fprintf (Fh, "		// Added by CDXCreator.\n");
			}

			fprintf (Fh, "\n		return TRUE;\n}\n\n");
			
			fprintf (Fh, "int PASCAL WinMain(HINSTANCE hInst, HINSTANCE hPrevInst, LPSTR lpCmdLine, int nCmdShow)\n");
			fprintf (Fh, "{\n");
			fprintf (Fh, "		MSG msg;\n\n");
			fprintf (Fh, "		if(!InitApp(hInst, nCmdShow)) return FALSE;\n\n");
			fprintf (Fh, "		while(1)\n");
			fprintf (Fh, "		{\n\n");
			fprintf (Fh, "			if(PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE))\n");
			fprintf (Fh, "			{\n\n");
			fprintf (Fh, "				if(!GetMessage(&msg, NULL, 0, 0 )) return msg.wParam;\n");
			fprintf (Fh, "				TranslateMessage(&msg);\n");
			fprintf (Fh, "				DispatchMessage(&msg);\n\n");
			fprintf (Fh, "			}\n");
			fprintf (Fh, "			else if(bActive)\n");
			fprintf (Fh, "			{\n\n");
			fprintf (Fh, "				Screen->Fill(0);\n\n");
			
			fprintf (Fh, "				// Here comes the main-game-loop!!\n");
			fprintf (Fh, "				// Add all things you would do in game here!\n\n");

			if (video_dlg.m_AddVideo!="")
			{
				if (Comments==1) fprintf (Fh, "				// Plays the Intro-Video ...\n");
				fprintf (Fh, "				IntroVideo->DrawFast (0, 0, Screen->GetBack());\n\n");
			}

			fprintf (Fh, "				Screen->Flip();\n\n");
			fprintf (Fh, "			}\n\n");
			fprintf (Fh, "			else WaitMessage();\n\n");
			fprintf (Fh, "		}\n\n");
			fprintf (Fh, "}\n");

			fclose (Fh);
			
			WinExec ("notepad " +m_AppName+".cpp" , SW_SHOW);
			MessageBox ("File successfully created!","CDXCreator",MB_OK+MB_ICONINFORMATION);
		
		}
		else MessageBox ("Error creating file! Aborted.","CDXCreator",MB_OK+MB_ICONSTOP);
	}
	else MessageBox ("Filename required!! Please type\nin the name in the Box!","CDXCreator",MB_OK+MB_ICONSTOP);
}

void CCDXCreatorDlg::OnChangeNameEdit() 
{
	UpdateData (TRUE);
}

void CCDXCreatorDlg::OnAddvideoButton() 
{
	int result=video_dlg.DoModal ();
	if (result==IDOK)
	{
		m_SeeVideo="";
		
		if (video_dlg.m_AddVideo!="")
		{
			m_SeeVideo="AVI loaded: "+video_dlg.m_AddVideo;
			if (video_dlg.m_LoopVideo==TRUE) m_SeeVideo+=" ,looped";
		}

		UpdateData (FALSE);
	}
}

void CCDXCreatorDlg::OnAddmusicButton() 
{
	int result=music_dlg.DoModal ();
	if (result==IDOK)
	{
		m_SeeMusic="";
		if (music_dlg.m_AddMusic!="")
		{
			m_SeeMusic="Music loaded: "+music_dlg.m_AddMusic;
		}
		UpdateData (FALSE);
	}
}

void CCDXCreatorDlg::OnLoadfontButton() 
{
	int result=font_dlg.DoModal ();
	if (result==IDOK)
	{
		m_SeeFont="";
		if (font_dlg.m_LoadDefaultFont==TRUE) m_SeeFont="Load default font";
		if (font_dlg.m_LoadDefaultFont==FALSE && font_dlg.m_Font!="")
		{
			m_SeeFont="Font to load: ";
			m_SeeFont+=font_dlg.m_Font;
		}
		UpdateData (FALSE);
	}
}

void CCDXCreatorDlg::OnVideomodesButton() 
{
	int result=vmode_dlg.DoModal ();	
	if (result==IDOK)
	{
		m_SeeVMode="";

		if (vmode_dlg.m_320==FALSE)
		{
			if (vmode_dlg.m_640==TRUE) m_SeeVMode+="640x480x";
			if (vmode_dlg.m_800==TRUE) m_SeeVMode+="800x600x";
			if (vmode_dlg.m_1024==TRUE) m_SeeVMode+="1024x768x";
			
			if (vmode_dlg.m_16Bit==TRUE) m_SeeVMode+="16Bit";
			if (vmode_dlg.m_24Bit==TRUE) m_SeeVMode+="24Bit";
			if (vmode_dlg.m_32Bit==TRUE) m_SeeVMode+="32Bit";
		}
		else m_SeeVMode+="320x200x8 (VGA)";
		UpdateData (FALSE);
	}
}

void CCDXCreatorDlg::OnComponentsButton() 
{
	int result=components_dlg.DoModal ();	
	if (result==IDOK) 
	{
		m_SeeCompo="";
		if (components_dlg.m_Input==TRUE) m_SeeCompo+="CDXInput";
		if (components_dlg.m_Music==TRUE) m_SeeCompo+=" ,CDXMusic";
		if (components_dlg.m_Sound==TRUE) m_SeeCompo+=" ,CDXSound";
		UpdateData (FALSE);
	}
}
