//////////////////////////////////////////////////////////////////////////////////
// $Source: /cvsroot/cdx/cdx3.0/tools/CDXResourceCompiler/cdxresource.h,v $
// $Author: hebertjo $
//
// $Log: cdxresource.h,v $
// Revision 1.1.1.1  2000/04/22 16:01:02  hebertjo
// Initial checkin of v3.0 to SourceForge CVS.
//
// Revision 1.2  1999/05/17 00:12:34  pietro
// debuged version.
//
// Revision 1.1  1999/05/16 22:04:37  pietro
// created new tool: CDXResourceCompiler for creating v2 resource files
//
// Revision 2.0  1999/05/01 13:51:16  bsimser
// Updated revision number to 2.0
//
// Revision 1.1.1.1  1999/05/01 04:10:56  bsimser
// Initial revision to cvs
//
// $Revision: 1.1.1.1 $
//////////////////////////////////////////////////////////////////////////////////
#ifndef CDXRESOURCE_H
#define CDXRESOURCE_H

//////////////////////////////////////////////////////////////////////////////////
// Structure used for each file entry in a resource file.
//////////////////////////////////////////////////////////////////////////////////
typedef struct
{
	long offset;
	char name[13];
} FILEENTRY, *LPFILEENTRY;


//version 2 resource files
typedef struct
{
	UINT	Signature;			//signature of the resource file, 'CDXR'
	UINT	Version;			//currently version 2
	UINT	NumOfEntries;		//number of resource file entries
} CDXRESOURCEFILEHEADER;

typedef UINT RESHANDLE;

//version 2 resource files
class CDXResDirEntry
{
public:
	CDXResDirEntry()	{pos=0; size=0; type=0; id=0;}		//constructor - so new will be cleared
	
	UINT		pos;					//position in RF of particular file
	UINT		size;					//size of particular file
	UCHAR		type;					//are 256 different types enough?
	UINT		id;						//id of the file
//the plan with id is that resource compiler will generate some c header file and
//you can use it in you'r project.
};



//////////////////////////////////////////////////////////////////////////////////
// The CDXResource class allows you to clump all types of files together for 
// your game. Files can be retrieved at runtime with the GetFile() method. There 
// is very little implied structure with the file so any type of file can be
// used as a resource.
//////////////////////////////////////////////////////////////////////////////////
class CDXResource
{
public:
	CDXResource(void);
	~CDXResource(void);

	BOOL Open(const char *Filename);
	BOOL OpenV1(const char *Filename);
	void Close(void);
	char* GetFile(const char *Filename);

public:
	LPFILEENTRY m_pFE;			// file entry structure for each file in a resource file
	int m_Infile;				// handle to the resource file
	int m_Outfile;				// handle to the output file
	int m_nFiles;				// number of files in a resource file

//version 2 resource files
	char	*fName;							//name of Resource File
	FILE	*fHandle;						//handle of Resource File
	UINT	version;						//version of resource file
	UINT	NumOfEntries;
	UINT	fSize;							//Resource File Size
	CDXResDirEntry	*Directory;

	RESHANDLE CDXResource::GetHandle(UINT id);
	UINT CDXResource::GetPos(RESHANDLE i);
	UINT CDXResource::GetSize(RESHANDLE i);
	UCHAR CDXResource::GetType(RESHANDLE i);
};

#endif
