/*---------------------------------------------------------------------------*/
/*                                                  Created: 24-APR-95 21:41 */
/* CLASS: SPoint                                                             */
/*                                              Last Change: 24-APR-95 21:41 */
/*---------------------------------------------------------------------------*/

class WPoint;
class SPoint
{

public:

	inline SPoint() {};
	inline SPoint(short sx, short sy);
    SPoint& operator+=( const SPoint& adder );
    SPoint& operator-=( const SPoint& subber );
    friend SPoint operator - ( const SPoint& one, const SPoint& two);
    friend SPoint operator + ( const SPoint& one, const SPoint& two);
    friend int operator == ( const SPoint& one, const SPoint& two);
    friend int operator != ( const SPoint& one, const SPoint& two);
	//SPoint operator = ( const WPoint& wp  ) const;

    short x,y;

};

inline SPoint::SPoint(short sx, short sy)
{
	x = sx;
	y = sy;
}

inline SPoint& SPoint::operator += ( const SPoint& adder )
{
    x += adder.x;
    y += adder.y;
    return *this;
}

inline SPoint& SPoint::operator -= ( const SPoint& subber )
{
    x -= subber.x;
    y -= subber.y;
    return *this;
}



/*---------------------------------------------------------------------------*/
/*                                                  Created: 24-APR-95 21:41 */
/* CLASS: SRect                                                         */
/*                                              Last Change: 24-APR-95 21:41 */
/*---------------------------------------------------------------------------*/
class SRect
{

public:

    SRect( short ax, short ay, short bx, short by );
    SRect( SPoint p1, SPoint p2 );
    SRect();

    void move( short aDX, short aDY );
    void grow( short aDX, short aDY );
    void intersect( const SRect& r );
    void Union( const SRect& r );
    BOOL contains( const SPoint& p ) const;
    BOOL operator == ( const SRect& r ) const;
    BOOL operator != ( const SRect& r ) const;
    BOOL isEmpty();

    SPoint a, b;

};

inline SRect::SRect( short ax, short ay, short bx, short by)
{
    a.x = ax;
    a.y = ay;
    b.x = bx;
    b.y = by;
}

inline SRect::SRect( SPoint p1, SPoint p2 )
{
    a = p1;
    b = p2;
}

inline SRect::SRect()
{
}

inline void SRect::move( short aDX, short aDY )
{
    a.x += aDX;
    a.y += aDY;
    b.x += aDX;
    b.y += aDY;
}

inline void SRect::grow( short aDX, short aDY )
{
    a.x -= aDX;
    a.y -= aDY;
    b.x += aDX;
    b.y += aDY;
}

inline void SRect::intersect( const SRect& r )
{
    a.x = max( a.x, r.a.x );
    a.y = max( a.y, r.a.y );
    b.x = min( b.x, r.b.x );
    b.y = min( b.y, r.b.y );
}

inline void SRect::Union( const SRect& r )
{
    a.x = min( a.x, r.a.x );
    a.y = min( a.y, r.a.y );
    b.x = max( b.x, r.b.x );
    b.y = max( b.y, r.b.y );
}

inline BOOL SRect::contains( const SPoint& p ) const
{
    return BOOL(
        p.x >= a.x && p.x < b.x && p.y >= a.y && p.y < b.y
        );
}

inline BOOL SRect::operator == ( const SRect& r) const
{
    return BOOL( a == r.a && b == r.b );
}

inline BOOL SRect::operator != ( const SRect& r ) const
{
    return BOOL( !(*this == r) );
}

inline BOOL SRect::isEmpty()
{
    return BOOL( a.x >= b.x || a.y >= b.y );
}

/*---------------------------------------------------------------------------*/
/*                                                  Created: 25-APR-95 15:15 */
/* CLASS: WPoint                                                             */
/*                                              Last Change: 25-APR-95 15:15 */
/*---------------------------------------------------------------------------*/

class WPoint
{

public:

    short x,y,z;

	inline WPoint() {};
	inline WPoint(short wx, short wy, short wz);
    inline WPoint& operator+=( const WPoint& adder );
    inline WPoint& operator-=( const WPoint& subber );
    friend WPoint operator - ( const WPoint& one, const WPoint& two);
    friend WPoint operator + ( const WPoint& one, const WPoint& two);
    friend int operator == ( const WPoint& one, const WPoint& two);
    friend int operator != ( const WPoint& one, const WPoint& two);

};


inline WPoint::WPoint(short wx, short wy, short wz)
{
	x = wx;
	y = wy;
	z = wz;
}


inline WPoint& WPoint::operator += ( const WPoint& adder )
{
    x += adder.x;
    y += adder.y;
    z += adder.z;
    return *this;
}

inline WPoint& WPoint::operator -= ( const WPoint& subber )
{
    x -= subber.x;
    y -= subber.y;
    z -= subber.z;
    return *this;
}


inline int operator == ( const WPoint& one, const WPoint& two )
{
    return one.x == two.x && one.y == two.y && one.z == two.z;
}




/*

inline SPoint SPoint::operator = ( const WPoint& wp  ) const
{
	SPoint sp;

	sp.x = wp.x - wp.y;
	sp.y = wp.y + wp.x;

	sp.x /= 4;
	sp.y = sp.y / 8 - wp.z/4;
	return sp;
}

*/




/*---------------------------------------------------------------------------*/
/*                                                  Created: 26-JAN-95 04:47 */
/* WorldToScreen                                                             */
/*                                                                           */
/*---------------------------------------------------------------------------*/
inline WorldToScreen(WPoint wp, SPoint& sp)
{
	sp.x = wp.x - wp.y;
	sp.y = wp.y + wp.x;

	sp.x /= 4;
	sp.y = sp.y / 4 - wp.z/4;

	sp.x = sp.x * (short) 0.6875;
	sp.y = sp.y * (short) 0.6875;

}

/*---------------------------------------------------------------------------*/
/*                                                  Created: 26-JAN-95 04:47 */
/* ScreenToWorld                                                             */
/*                                                                           */
/*---------------------------------------------------------------------------*/
inline ScreenToWorld(SPoint sp, WPoint& wp)
{
	sp.x = sp.x * 4;
	sp.y = sp.y * 8;

	wp.x = (sp.x + sp.y) / 2;
	wp.y = wp.x - sp.x;
}
