//////////////////////////////////////////////////////////////////////////////////
// $Source: /cvsroot/cdx/cdx3.0/tools/CDXResourceCompiler/token.cpp,v $
// $Author: hebertjo $
//
// $Log: token.cpp,v $
// Revision 1.1.1.1  2000/04/22 16:01:15  hebertjo
// Initial checkin of v3.0 to SourceForge CVS.
//
// Revision 1.1  1999/05/16 22:04:37  pietro
// created new tool: CDXResourceCompiler for creating v2 resource files
//
//
// $Revision: 1.1.1.1 $
//////////////////////////////////////////////////////////////////////////////////
#ifdef SAVE_RCSID
static char rcsid = "@(#) $Id: token.cpp,v 1.1.1.1 2000/04/22 16:01:15 hebertjo Exp $";
#endif


#include "stdafx.h"


token::token(char *fname)
{

	if(NULL==(INIstream = fopen(fname,"rt")))
	{
		exit (-1);
		//Error(errFile, EMARK, fname);
	}
	LineNumber=1;
}


// Transforms all white spaces to blanks

char token::towhite(char c)
{
  if (c=='\n') LineNumber++;

  if 	(
  		  (c=='\n')
  		||(c=='\t')
		  )
	     return(' ');

  return(c);
}

// Removes blank space before next token

token::rmspace()
{
  char c;
  while (((c=towhite(fgetc(INIstream)))==' ') && !feof(INIstream));
  ungetc(c,INIstream);
}

// Comment Killer

token::Comment_Killer()
{
  char c;

  c='\0';
  while (c != '\n' && !feof(INIstream))
  {
    c = fgetc(INIstream);
  }
  LineNumber++;
}



char token::CheckSeparator()
{
	char	c;

	rmspace();
	c=fgetc(INIstream);
	ungetc(c,INIstream);
	return(c);
}


char token::GetSeparator()
{
	char str[SLEN];

	GetToken(str);

	if 	(
  		  (*str==',')
		||(*str=='+')
		||(*str=='=')
		  )
		return(*str);

	return('\0');

}


int token::GetInt()
{
	char str[SLEN];
	int val;

	GetToken(str);

	val=atoi(str);
	if(val==0 && *str!='0')
		exit (-1);
		//Error(errSyntax, EMARK);
/*
	if(val<-65535||val>65535)
		Error(ERR_RANGE,str);
*/
  return(val);
}

void token::GetLine(char s[])
{
	char	c;
	int		x=0;

	while (!feof(INIstream) && x<(SLEN-1))
	{
		s[x++]=c=fgetc(INIstream);
		if (c=='\n')
		{
			s[--x]='\0';
			break;
		}
	}
}


// Get next token from stdin

token::GetToken(char s[])
{
	char c;
	int x;

	x=0; s[0]=c='\0';

	rmspace();

	while (!feof(INIstream) && x<(SLEN-1))
	{
		s[x++]=c=toupper(towhite(fgetc(INIstream)));
		if (c==' ')
		{
			s[--x]='\0';
			break;
		}
		if (c=='='||c==','||c=='+')
		{
			if(x==1)
			{
				s[x]='\0';				//return only at start of token
				break;

			}
			else
			{
				s[--x]='\0';			//use as stop char
  				ungetc(c,INIstream);
				break;
			}
		}
		if (c=='#'|| c==';')
		{
			x--;
			Comment_Killer();
			rmspace();
		}
	}
}
