//////////////////////////////////////////////////////////////////////////////////
// $Source: /cvsroot/cdx/cdx3.0/tools/CDXResourceCompiler/worldobject.h,v $
// $Author: hebertjo $
//
// $Log: worldobject.h,v $
// Revision 1.1.1.1  2000/04/22 16:01:15  hebertjo
// Initial checkin of v3.0 to SourceForge CVS.
//
// Revision 1.1  1999/05/23 04:10:47  pietro
// added
//
// Revision 1.1.1.1  1999/05/20 12:31:27  pietro
// Pietro's Nonamed Isometric Engine
//
//
// $Revision: 1.1.1.1 $
//////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////
// 
//////////////////////////////////////////////////////////////////////////////////

#define FRMHANDLE unsigned short
#define UINT16 unsigned short
#define UINT8 unsigned char

typedef	UINT16	WOFrmIdx;
typedef UINT16	WOCacheSlotIdx;

class WOFrame
{
public:
	WOFrmIdx		FrameId;				//relative id
	SPoint			xyoffset;				//center of object for iso space
	SPoint			Ssize;					//needed???
	WPoint			Wsize;
	RECT			SrcRect;

};

class WOStockObject
{
public:
	
	WOStockObject() {};
	WOStockObject(CDXScreen *cScreen, BYTE cmemoryType) {};
	~WOStockObject() {};
	Create(CDXScreen *cScreen, BYTE cmemoryType);
	BOOL LoadFromRes(CDXResource *res, RESHANDLE i);
	BOOL Draw(FRMHANDLE fh, LONG x, LONG y);
	BOOL Draw(FRMHANDLE fh, SPoint sp);
	BOOL Draw(FRMHANDLE fh, WPoint wp);


	UINT16		id;					//symbolic id of the object
	char		*name;				//symbolic name (compatibility mode)
	UINT8		type;				//simple, animated, multi.....
	CDXSurface	*Surface;			//bitmap
	WOFrame		*Frame;				//[]; description of frames in bitmap
	WOFrmIdx	TotalFrames;		//size of Frame array
	WPoint		WorldSize;				//general object size
	SPoint		ScreenSize;			//tmp only
	
	CDXScreen *pScreen;
	BYTE memoryType;
};

class WOAnimSequence
{
public:
	UINT16		id;				//anim seq id
	char		*name;			//name of seq.
	WOFrmIdx	From;
	WOFrmIdx	To;
	UINT16		Speed;
};

class WOAnimStockObject : public WOStockObject
{
public:
	UINT16			id;
	char			*name;
	WOAnimSequence	*SeqTab;		//[];
	UINT16			TotalSeqTab;
};

class WOCacheSlot
{
public:
	WOCacheSlot();

	WOStockObject	*Object;
	UINT32			Time;					//systime when loaded - used for aging
	UINT16			Locks;					//count of open referencies, 0=Discard Eligible
	//BOOL			Free;
	//WOCacheSlotIdx	PrevFree;
	WOCacheSlotIdx	NextFree;

};

class WOCache
{
public:
	WOCache(CDXResource *ires, CDXScreen *cScreen, BYTE cmemoryType);
	~WOCache();

	WOStockObject		*GetInstance(UINT id);
	
	WOCacheSlotIdx		alloc();
	void				free(WOCacheSlotIdx i);
	WOCacheSlotIdx		find(UINT id);

	WOCacheSlot			*Slot;		//[];
	WOCacheSlotIdx		FirstFree;
	WOCacheSlotIdx		LastFree;
	WOCacheSlotIdx		NumFree;
	WOCacheSlotIdx		TotalSlots;			//size - inclusive.

	CDXResource			*res;

	CDXScreen *pScreen;
	BYTE memoryType;
};

