// MapConverterDlg.cpp : implementation file
//

#include "stdafx.h"
#include "MapConverter.h"
#include "MapConverterDlg.h"
#include "MapMakerMap.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMapConverterDlg dialog

CMapConverterDlg::CMapConverterDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMapConverterDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMapConverterDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	m_Layer = 0;
}

void CMapConverterDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMapConverterDlg)
	DDX_Control(pDX, IDC_EDIT2, m_EditBox2);
	DDX_Control(pDX, IDC_EDIT1, m_EditBox1);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMapConverterDlg, CDialog)
	//{{AFX_MSG_MAP(CMapConverterDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_RADIO1, OnRadio1)
	ON_BN_CLICKED(IDC_RADIO2, OnRadio2)
	ON_BN_CLICKED(IDC_RADIO3, OnRadio3)
	ON_BN_CLICKED(IDC_RADIO4, OnRadio4)
	ON_BN_CLICKED(IDC_MAPFILEBUTTON, OnMapfilebutton)
	ON_BN_CLICKED(IDC_OUTPUTFILEBUTTON, OnOutputfilebutton)
	ON_BN_CLICKED(IDC_CONVERTBUTTON, OnConvertbutton)
	ON_BN_CLICKED(IDC_BUTTON1, OnAbout)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMapConverterDlg message handlers

BOOL CMapConverterDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here

   CheckRadioButton(IDC_RADIO1,IDC_RADIO4,IDC_RADIO1);
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CMapConverterDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CMapConverterDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

HCURSOR CMapConverterDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CMapConverterDlg::OnRadio1() 
{
	m_Layer = 0;
}

void CMapConverterDlg::OnRadio2() 
{
	m_Layer = 1;
}	

void CMapConverterDlg::OnRadio3() 
{
	m_Layer = 2;
}

void CMapConverterDlg::OnRadio4() 
{
	m_Layer = 3;
}

void CMapConverterDlg::OnMapfilebutton() 
{
	CFileDialog openfiledlg(TRUE, "map", NULL);

	if(openfiledlg.DoModal() == IDOK)
	{
		m_MapMakerFile = openfiledlg.GetPathName();
		m_EditBox1.SetWindowText(m_MapMakerFile);
	}

}

void CMapConverterDlg::OnOutputfilebutton() 
{
	CFileDialog openfiledlg(FALSE, "map", NULL);

	if(openfiledlg.DoModal() == IDOK)
	{
		m_OutputFile = openfiledlg.GetPathName();
		m_EditBox2.SetWindowText(m_OutputFile);
	}
	
}

void CMapConverterDlg::OnConvertbutton() 
{
	int height, width;
	MapMakerMap* srcmap;
	FILE *fp;
	int SIZE;
	int* DATA;

   if(m_MapMakerFile.IsEmpty())
   {
      AfxMessageBox("Please specify MapMaker file to convert!", MB_OK | MB_ICONEXCLAMATION);
      return;
   }
   
   if(m_OutputFile.IsEmpty())
   {
      AfxMessageBox("Please specify output CDX map file!", MB_OK | MB_ICONEXCLAMATION);
      return;
   }

	srcmap = new MapMakerMap();

	if(srcmap->Create(m_MapMakerFile) != TRUE)
	{
		AfxMessageBox("Could not create map from MapMaker file, check filename and version ( must be 1.1)", MB_OK | MB_ICONEXCLAMATION);
		return;
	}

	height = srcmap->GetHeight();
	width = srcmap->GetWidth();
	

	fp = fopen(m_OutputFile, "wb");
	if(fp == NULL)
	{
		AfxMessageBox("Failed to create output file!", MB_OK | MB_ICONEXCLAMATION);
		return;
	}

	fwrite(&width, sizeof(int), 1, fp);
	fwrite(&height, sizeof(int), 1, fp);

	SIZE = width * height;

	DATA = new int[SIZE];

	for(int y=0;y<height;y++)
		for(int x=0;x<width;x++)
			DATA[(y * width) + x] = srcmap->GetTileAt(x,y,m_Layer);


	fwrite(DATA, sizeof(int), SIZE, fp);

	fclose(fp);

	delete srcmap;

   AfxMessageBox("Conversion done!", MB_OK | MB_ICONINFORMATION);
}

void CMapConverterDlg::OnAbout() 
{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
}
