/////////////////////////////////////////////////////////////////////////////
// MainFrm.cpp : implementation of the CMainFrame class
/////////////////////////////////////////////////////////////////////////////

#include "StdAfx.h"
#include "Editor.h"
#include "MainFrm.h"
#include "MenuDlg.h"
#include "AboutDlg.h"
#include "CDX.h"

char MOUSE[] = "IDB_MOUSE";
char FRAME[] = "IDB_FRAME";
char TILES[] = "IDB_TILES";

/////////////////////////////////////////////////////////////////////////////
// CMainFrame
/////////////////////////////////////////////////////////////////////////////

IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_LBUTTONDOWN()
	ON_WM_RBUTTONDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction
/////////////////////////////////////////////////////////////////////////////

CMainFrame::CMainFrame()
{
  CString ClassName = AfxRegisterWndClass(
                        0,
                        NULL,
                        HBRUSH(GetStockObject(BLACK_BRUSH)),
                        AfxGetApp()->LoadIcon(IDR_MAINFRAME));  

	CreateEx(
//		WS_EX_TOPMOST,
0,
					 ClassName, 
					 "Editor", 
					 WS_POPUP | WS_SYSMENU,
					 0,0, 
					 GetSystemMetrics(SM_CXSCREEN),
					 GetSystemMetrics(SM_CYSCREEN),
					 NULL,
					 NULL);
}

CMainFrame::~CMainFrame()
{
	delete Screen;
	delete Tiles;
	delete Map;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	return CFrameWnd::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers
/////////////////////////////////////////////////////////////////////////////

BOOL CMainFrame::InitAll(void)
{
	RECT r = {592, 76, 624, 108};


	Screen = new CDXScreen();
	if (FAILED(Screen->CreateFullScreen(m_hWnd, 640, 480, 16)))
//	if (FAILED(Screen->CreateWindowed(m_hWnd, 640, 480)))
		CDXError(NULL, "Unable to set video mode");

	TILEWIDTH = 32;
	TILEHEIGHT = 32;
	TILENUM = 0;

	Tiles = new CDXTile();
	if (Tiles->Create(Screen, TILES, TILEWIDTH, TILEHEIGHT, TILENUM)==FALSE)
		CDXError(Screen, "Unable to load Tiles");

	Tiles->SetColorKey(0);
//	Tiles->SetClipRect(&r);

	int x = Tiles->GetWidth();
	int y = Tiles->GetHeight();

	Map = new CDXMap(Tiles, Screen);
	Map->Create(256, 256, 0);
	Map->ScreenTileSize(18,15);
	Map->MoveTo(0,0);

	Frame = new CDXSurface();
	Frame->Create(Screen, FRAME);

	Cursor = new CDXSurface();
	Cursor->Create(Screen, MOUSE);
	Cursor->SetColorKey(0);

	GotTile = 0;
	ScrollRate = 4;

	for(int i = 0; i < 11; i++) TileList[i] = i;

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers
/////////////////////////////////////////////////////////////////////////////

void CMainFrame::RenderFrame(void)
{
	// Get mouse position
	GetCursorPos(&Mouse);

	if(GetAsyncKeyState(VK_ESCAPE))
	{
		ShowCursor(TRUE);
		CMenuDlg Menu;
		Menu.DoModal();
		ScrollRate = Menu.m_ScrollRate;
		ShowCursor(FALSE);
	}

	// Get keyboard state
	if(GetAsyncKeyState(VK_UP)) Map->ScrollUp(ScrollRate);
	if(GetAsyncKeyState(VK_DOWN)) Map->ScrollDown(ScrollRate);
	if(GetAsyncKeyState(VK_LEFT))	Map->ScrollLeft(ScrollRate);
	if(GetAsyncKeyState(VK_RIGHT)) Map->ScrollRight(ScrollRate);
	if(GetAsyncKeyState(VK_F1))
	{
		ShowCursor(TRUE);
		CAboutDlg About;
		About.DoModal();
		ShowCursor(FALSE);
	}
	if(GetAsyncKeyState(VK_F12)) PostQuitMessage(0);
	if(GetAsyncKeyState(VK_HOME))	Map->MoveTo(0,0);
	if(GetAsyncKeyState(VK_PRIOR)) Map->ScrollUp(480);
	if(GetAsyncKeyState(VK_NEXT)) Map->ScrollDown(480);

	// Mouse scrolling
	if(Mouse.y == 0)   Map->ScrollUp(ScrollRate);
	if(Mouse.y == 479) Map->ScrollDown(ScrollRate);
	if(Mouse.x == 0)   Map->ScrollLeft(ScrollRate);
	if(Mouse.x == 639) Map->ScrollRight(ScrollRate);

	Screen->GetBack()->Fill(0);
	Frame->DrawBlk(Screen->GetBack(), Screen->GetWidth()-Frame->GetWidth(), 0);
	DrawTile();
	Map->Draw(Screen->GetBack());

	int mapx = (Map->GetPosX() + Mouse.x) / TILEWIDTH;
	int mapy = (Map->GetPosY() + Mouse.y) / TILEHEIGHT;

	char String[12];
	sprintf(String, "(%d, %d)", mapx, mapy);

	Screen->GetBack()->GetDC();
	Screen->GetBack()->TextXY(580, 456, 0, String);
	Screen->GetBack()->ReleaseDC();
	
//	Cursor->DrawClipped(Mouse.x, Mouse.y, Screen->GetBack());
	Cursor->DrawTrans(Screen->GetBack(), Mouse.x, Mouse.y);
	Screen->Flip();
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame mouse message handlers
/////////////////////////////////////////////////////////////////////////////

void CMainFrame::OnLButtonDown(UINT nFlags, CPoint point) 
{
	if(Mouse.x < 576) PutTile();
	if(Mouse.x > 592 && Mouse.x < 624 && Mouse.y > 60 && Mouse.y < 76) GetTileDown();
	if(Mouse.x > 592 && Mouse.x < 624 && Mouse.y > 428 && Mouse.y < 444) GetTileUp();

	// Select a tile from the list
	if(Mouse.x > 592 && Mouse.x < 624)
	{
		if(Mouse.y > 76 && Mouse.y < 108)  GotTile = TileList[0];
		if(Mouse.y > 108 && Mouse.y < 140) GotTile = TileList[1];
		if(Mouse.y > 140 && Mouse.y < 172) GotTile = TileList[2];
		if(Mouse.y > 172 && Mouse.y < 204) GotTile = TileList[3];
		if(Mouse.y > 204 && Mouse.y < 236) GotTile = TileList[4];
		if(Mouse.y > 236 && Mouse.y < 268) GotTile = TileList[5];
		if(Mouse.y > 268 && Mouse.y < 300) GotTile = TileList[6];
		if(Mouse.y > 300 && Mouse.y < 332) GotTile = TileList[7];
		if(Mouse.y > 332 && Mouse.y < 364) GotTile = TileList[8];
		if(Mouse.y > 364 && Mouse.y < 396) GotTile = TileList[9];
		if(Mouse.y > 396 && Mouse.y < 428) GotTile = TileList[10];
		if(Mouse.y > 428 && Mouse.y < 460) GotTile = TileList[11];
	}

	CFrameWnd::OnLButtonDown(nFlags, point);
}

void CMainFrame::OnRButtonDown(UINT nFlags, CPoint point) 
{
	if(Mouse.x < 576) GetTile();
	
	CFrameWnd::OnRButtonDown(nFlags, point);
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame PutTile
/////////////////////////////////////////////////////////////////////////////

void CMainFrame::PutTile(void)
{
	int mapx = (Map->GetPosX() + Mouse.x) / TILEWIDTH;
	int mapy = (Map->GetPosY() + Mouse.y) / TILEHEIGHT;

	Map->SetTile(mapx, mapy, GotTile);
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame GetTile
/////////////////////////////////////////////////////////////////////////////

void CMainFrame::GetTile(void)
{
	int mapx = (Map->GetPosX() + Mouse.x) / TILEWIDTH;
	int mapy = (Map->GetPosY() + Mouse.y) / TILEHEIGHT;

	GotTile = Map->GetTile(mapx, mapy);

	for(int i = 0; i < 11; i++) TileList[i] = GotTile + i;
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame GetTileUp
/////////////////////////////////////////////////////////////////////////////

void CMainFrame::GetTileUp(void)
{
	if(TileList[11] < TILENUM)	for(int i = 0; i < 11; i++) TileList[i]++;
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame GetTileDown
/////////////////////////////////////////////////////////////////////////////

void CMainFrame::GetTileDown(void)
{
	if(TileList[0] > 0)	for(int i = 0; i < 11; i++) TileList[i]--;
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame DrawTile
/////////////////////////////////////////////////////////////////////////////

void CMainFrame::DrawTile(void)
{
	for(int i = 0; i < 11; i++)
		Tiles->Draw(592, 76+(i * TILEWIDTH), Screen->GetBack(), CDXBLT_BLK, TileList[i]);
}
