// AnimDlg.cpp : implementation file
//

#include "stdafx.h"
#include "mdimap.h"
#include "AnimDlg.h"
#include "MapFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAnimDlg dialog


CAnimDlg::CAnimDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CAnimDlg::IDD, pParent)
{
	m_InWindow=FALSE;	
	m_Screen = NULL;
	//{{AFX_DATA_INIT(CAnimDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}

CAnimDlg::~CAnimDlg()
{
	SAFEDELETE(m_Screen);
}

BOOL CAnimDlg::InitCDX()
{
	m_Screen = new CDXScreen;

	m_Screen->CreateWindowed(m_hWnd,GetSystemMetrics(SM_CXSCREEN), GetSystemMetrics(SM_CYSCREEN));

	return TRUE;

}

void CAnimDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAnimDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CAnimDlg, CDialog)
	//{{AFX_MSG_MAP(CAnimDlg)
	ON_WM_HSCROLL()
	ON_WM_KILLFOCUS()
	ON_WM_LBUTTONDOWN()
	ON_WM_RBUTTONDOWN()
	ON_WM_SIZE()
	ON_WM_VSCROLL()
	ON_WM_MOUSEMOVE()
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAnimDlg message handlers

void CAnimDlg::Paint() 
{
	DrawScreen( );
}

BOOL CAnimDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	if(!InitCDX()) return FALSE;

	m_SelAnim = -1;
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CAnimDlg::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{

	CMapFrame* pParent = STATIC_DOWNCAST(CMapFrame, GetParentFrame());
	UINT pos = GetScrollPos( SB_HORZ );

	pos = pParent->ScrollBar( nSBCode, pos, nPos, m_yTiles );
	SetScrollPos( SB_HORZ, pos );

	PostMessage(WM_PAINT);

	CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
}

void CAnimDlg::OnKillFocus(CWnd* pNewWnd) 
{
	if( m_InWindow )
	{
		m_InWindow=FALSE;
		PostMessage(WM_PAINT);
	}
	CDialog::OnKillFocus(pNewWnd);
}

void CAnimDlg::OnLButtonDown(UINT nFlags, CPoint point) 
{
	CMapFrame* pParent = STATIC_DOWNCAST(CMapFrame, GetParentFrame());
	CDXTile *tiles = pParent->GetTiles(pParent->GetSelLayer());

	if( tiles )
	{
		m_SelAnim = (point.y/32) + GetScrollPos( SB_VERT );
		if( m_SelAnim<tiles->GetAnimCount( ) )
		{
			m_Pos = (point.x/32) + GetScrollPos( SB_HORZ );

			if( m_Pos <= tiles->GetAnimData(m_SelAnim)->num )
			{
				pParent->SetBrush( pParent->GetSelBrush(), 1, 1, 0, m_SelAnim );
//				DELETEARRAY( pParent->m_Brush[pParent->GetSelLayer()] );
//				pParent->m_Brush[pParent->GetSelLayer()] = new int[1];
//				pParent->m_Brush[pParent->GetSelLayer()][0] = (-m_SelAnim)-1;
//				pParent->m_BrushX[pParent->GetSelLayer()] = 1;
//				pParent->m_BrushY[pParent->GetSelLayer()] = 1;
//				pParent->UpdateMenu( );
			}
			else m_Pos=0;
		}
		else if( m_SelAnim==tiles->GetAnimCount( ) )
		{
			m_Pos=0;
		}
		else m_SelAnim = -1;

		PostMessage(WM_PAINT);
	}

	CDialog::OnLButtonDown(nFlags, point);
}

void CAnimDlg::OnRButtonDown(UINT nFlags, CPoint point) 
{
	CMapFrame* pParent = STATIC_DOWNCAST(CMapFrame, GetParentFrame());
	CDXTile *tiles = pParent->GetTiles(pParent->GetSelLayer());

	if( tiles )
		if( m_SelAnim>-1 && tiles->GetAnimCount( ) )
			pParent->PopUp( this, IDR_ANIM, point );

	CDialog::OnRButtonDown(nFlags, point);
}

void CAnimDlg::OnSize(UINT nType, int cx, int cy) 
{
	CMapFrame* pParent = STATIC_DOWNCAST(CMapFrame, GetParentFrame());
	CDialog::OnSize(nType, cx, cy);
	
	m_xTiles=cx/32;
	m_yTiles=cy/32;

	CDXTile *tiles = pParent->GetTiles(pParent->GetSelLayer());
	if( tiles )
		SetScrollRange( SB_VERT, 0, (tiles->GetAnimCount( )+1)-m_yTiles );
}

void CAnimDlg::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	CMapFrame* pParent = STATIC_DOWNCAST(CMapFrame, GetParentFrame());
	UINT pos = GetScrollPos( SB_VERT );

	pos = pParent->ScrollBar( nSBCode, pos, nPos, m_xTiles );
	SetScrollPos( SB_VERT, pos );

	PostMessage(WM_PAINT);

	CDialog::OnVScroll(nSBCode, nPos, pScrollBar);
}

void CAnimDlg::OnMouseMove(UINT nFlags, CPoint point) 
{
	if( m_InWindow == FALSE )
	{
		SetFocus( );
		m_InWindow=TRUE;
	}
	
	CDialog::OnMouseMove(nFlags, point);
}


////////////////////////////////////////////////////////////////////////////
// Miscellaneous functions

void CAnimDlg::DrawScreen( void )
{
	int y, y2;
	CMapFrame* pParent = STATIC_DOWNCAST(CMapFrame, GetParentFrame());

	CDXTile *tiles = pParent->GetTiles(pParent->GetSelLayer());

	if(tiles == NULL)
		return;

	m_Screen->GetBack( )->Fill( 10 );

	if( tiles )
	{
		for( y=0, y2=GetScrollPos( SB_VERT ); y2<tiles->GetAnimCount( )+1 && y<=m_yTiles; y2++ )
		{	
			if( y2>=tiles->GetAnimCount( ) )
			{
				m_Screen->GetBack( )->FillRect( 0, y*32, 32, y*32+32, 0 );
			}
			else
			{
				int xs = GetScrollPos( SB_HORZ);
				int xadd=0;

				if( xs==0 )
				{
					tiles->Draw( 0, y*32, m_Screen->GetBack( ), 0, -y2-1 );
					xadd=32;
				}
				else xs-=1;

				for( int x=xs; x<tiles->GetAnimData(y2)->num && x<m_xTiles; x++ )
				{
					int tile = tiles->GetAnimData(y2)->anim[x];
					tiles->Draw( (x-xs)*32+xadd, y*32, m_Screen->GetBack( ), 0, tile );
				}
			}
			y++;
		}

		m_Screen->GetBack( )->InvertColors( (m_Pos-GetScrollPos( SB_HORZ ))*32, (m_SelAnim-GetScrollPos( SB_VERT ))*32, (m_Pos-GetScrollPos( SB_HORZ ))*32+32, (m_SelAnim-GetScrollPos( SB_VERT ))*32+32 );
	}

	m_Screen->Flip( FALSE, FALSE ); 
}

void CAnimDlg::AddTile(long nr)
{
	if( m_SelAnim > -1 )
	{
		CMapFrame* pParent = STATIC_DOWNCAST(CMapFrame, GetParentFrame());
		CDXTile *tiles = pParent->GetTiles(pParent->GetSelLayer());

		if( m_SelAnim >= tiles->GetAnimCount( ) )
		{
			tiles->AddAnim( 10, 0, 0, 0, &nr, 1 );
		}
		else
		{
			int pos = m_Pos;
			if( pos==0 ) pos = tiles->GetAnimData(m_SelAnim)->num;
			else pos--;

			tiles->InsertTile( m_SelAnim, pos, nr );
		}

		SetScrollRange( SB_VERT, 0, (tiles->GetAnimCount( )+1)-m_yTiles );

		PostMessage(WM_PAINT);
	}
}
void CAnimDlg::OnPaint() 
{
	Paint();
	CDialog::OnPaint();
}
