// MapFrm.h : interface of the CMapFrame class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_MapFrm_H__CC550E22_6193_11D4_A33C_0040055797F1__INCLUDED_)
#define AFX_MapFrm_H__CC550E22_6193_11D4_A33C_0040055797F1__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "AnimDlg.h"
#include "MapDlg.h"
#include "TilesDlg.h"
#include "ToolsDlg.h"

#define TIMER_ID 1
#define TIMER_RATE 100

//sUndo and sConfig for use by CMapFrame
struct sUndo
{	int x, y, Tile;	};

struct sConfig
{
	DWORD m_ColorKeyRGB;
	DWORD m_CaptionRGB, m_CaptionHalfRGB;
	BOOL m_ColorKey, m_DrawTrans;
	BOOL m_XorTiles, m_PlayAnim;
	int m_AllLayers;
	int m_LeftLine;
};


class CMapFrame : public CMDIChildWnd
{
	DECLARE_DYNCREATE(CMapFrame)
public:

	//Constructors/Destructers
	//NOTE: May want to add Constructor for loading map/tileset at creation
	CMapFrame();
	virtual ~CMapFrame();

	//Generally useful functions
	void PopUp( CWnd *wnd, int id, CPoint point );
	void CreateMap(CStringArray *TileSets, int Layers, int Height, int Width, int Fill = 0);
	void LoadCfg();
	BOOL LoadMap(CString str);
	BOOL LoadTiles(CStringArray *StrArray);
	void ResetCfg();
	BOOL SaveMap( CString *str );
	UINT ScrollBar( UINT nSBCode, UINT nPos, UINT nTHUMBPOS, UINT nPage );
	void SizeWindows();
	void UpdateMenu( void );

	//Accessors for internal Dialogs
	CAnimDlg*	GetAnimDlg() {return m_AnimDlg;}
	CMapDlg*	GetMapDlg() {return m_MapDlg;}
	CTilesDlg*	GetTilesDlg() {return m_TilesDlg;}

	CDXMap*		GetMap(int layer);
	CDXTile*	GetTiles(int layer);


	//NOTE: Still need to work on privatization, just lazy...

	int* GetBrush(int brushnum);
	int GetBrushX(int brushnum);
	int GetBrushY(int brushnum);
	void SetBrush(int brushnum, int height, int width, int left, int top);

	BOOL GetPaintBit() {return m_PaintBit;}
	BYTE GetSelBit() {return m_SelBit;}
	BYTE GetSelBrush() {return m_SelBrush;}
	int GetSelLayer() {return m_SelLayer;}
	BOOL		m_StoreUndo, m_Changed;
	sConfig		cfg;

	CArray<sUndo,sUndo&> m_Undo;

private:

	CAnimDlg*	m_AnimDlg;
	CMapDlg*	m_MapDlg;
	CTilesDlg*	m_TilesDlg;
	
	CDXMap		**m_Map;
	CDXTile		**m_Tiles;

	int			*m_Brush[5];
	int			m_BrushX[5], m_BrushY[5];
	BYTE		m_SelBrush, m_SelBit;
	BOOL		m_PaintBit;
	int			m_SelLayer;
	int			m_NumLayers;
	CStringArray	*m_TileSet;
//	char		m_TileSet[2][21];


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMapFrame)
	public:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	//}}AFX_VIRTUAL

#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

// Generated message map functions
protected:
	//{{AFX_MSG(CMapFrame)
	afx_msg void OnFileClose();
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnFileOpenmap();
	afx_msg void OnAddtoanim();
	afx_msg void OnAnimDel();
	afx_msg void OnAnimEdit();
	afx_msg void OnBrushLoad();
	afx_msg void OnBrushSave();
	afx_msg void OnDelbrush();
	afx_msg void OnFileSavemap();
	afx_msg void OnLayer1();
	afx_msg void OnLayer3();
	afx_msg void OnLayerLoad();
	afx_msg void OnSelbit1();
	afx_msg void OnSelbit2();
	afx_msg void OnSelbit3();
	afx_msg void OnSelbit4();
	afx_msg void OnSelbit5();
	afx_msg void OnSelbit6();
	afx_msg void OnSelblock();
	afx_msg void OnSelnobit();
	afx_msg void OnTilesOpen();
	afx_msg void OnToolsOptions();
	afx_msg void OnToolsUndo();
	afx_msg void OnWalkbits1();
	afx_msg void OnWalkbits2();
	afx_msg void OnWalkbits3();
	afx_msg void OnWalkbits4();
	afx_msg void OnWalkbits5();
	afx_msg void OnWalkbits6();
	afx_msg void OnWalkbitsPaint();
	afx_msg void OnBrush1();
	afx_msg void OnBrush2();
	afx_msg void OnBrush3();
	afx_msg void OnBrush4();
	afx_msg void OnBrush5();
	afx_msg void OnPaint();
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_MapFrm_H__CC550E22_6193_11D4_A33C_0040055797F1__INCLUDED_)
