// mdimap.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "mdimap.h"
#include "resource.h"

#include "MainFrm.h"
#include "MapFrm.h"
#include "MapDlg.h"
#include "TilesDlg.h"

#include "NewMap.h"
#include <initguid.h>


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMdimapApp

BEGIN_MESSAGE_MAP(CMdimapApp, CWinApp)
	//{{AFX_MSG_MAP(CMdimapApp)
	ON_COMMAND(ID_HELP_ABOUT, OnHelpAbout)
	ON_COMMAND(ID_FILE_EXIT, OnFileExit)
	ON_COMMAND(ID_FILE_OPENNEWMAP, OnFileOpennewmap)
	ON_COMMAND(ID_FILE_NEWMAP, OnFileNewmap)
	ON_COMMAND(ID_FILE_OPENNEWMAP2, OnFileOpennewmap)
	ON_COMMAND(ID_FILE_NEWMAP2, OnFileNewmap)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMdimapApp construction

CMdimapApp::CMdimapApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CMdimapApp object

CMdimapApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CMdimapApp initialization

BOOL CMdimapApp::InitInstance()
{

	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif

	// To create the main window, this code creates a new frame window
	// object and then sets it as the application's main window object.

	CMDIFrameWnd* pFrame = new CMainFrame;
	m_pMainWnd = pFrame;

	// create main MDI frame window
	if (!pFrame->LoadFrame(IDR_MAINFRAME))
		return FALSE;

	// try to load shared MDI menus and accelerator table
	//TODO: add additional member variables and load calls for
	//	additional menu types your application may need. 

	HINSTANCE hInst = AfxGetResourceHandle();
	m_hMapMenu  = ::LoadMenu(hInst, MAKEINTRESOURCE(IDR_MAPMENU));
	m_hMDIAccel = ::LoadAccelerators(hInst, MAKEINTRESOURCE(IDR_MDIMAPTYPE));



	// The main window has been initialized, so show and update it.
	pFrame->ShowWindow(m_nCmdShow);
	pFrame->UpdateWindow();

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CMdimapApp message handlers

int CMdimapApp::ExitInstance() 
{
	//TODO: handle additional resources you may have added
	if (m_hMapMenu != NULL)
		FreeResource(m_hMapMenu);
	if (m_hMDIAccel != NULL)
		FreeResource(m_hMDIAccel);


	return CWinApp::ExitInstance();
}


/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
		// No message handlers
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};


CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// App command to run the dialog
void CMdimapApp::OnHelpAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}
void CMdimapApp::OnFileExit() 
{
	m_pMainWnd->PostMessage(WM_CLOSE);
}

void CMdimapApp::OnFileNewmap() 
{
	CNewMap dlg;

	if(dlg.DoModal() == IDOK){
		CMainFrame* pFrame = STATIC_DOWNCAST(CMainFrame, m_pMainWnd);

		// create a new MDI child window
		CMapFrame* pMap = STATIC_DOWNCAST( CMapFrame, pFrame->CreateNewChild(
				RUNTIME_CLASS(CMapFrame), IDR_MAPCAP, m_hMapMenu, m_hMDIAccel) );

		pMap->CreateMap(&dlg.m_TileSets, dlg.m_NumLayers, dlg.m_Height, dlg.m_Width, dlg.m_Fill);		
	}

}

void CMdimapApp::OnFileOpennewmap() 
{
	CString Filter = "Map Files (*.map)|*.map|All Files (*.*)|*.*||";
	CFileDialog FileDlg(TRUE, "*.map", NULL, OFN_FILEMUSTEXIST, Filter, NULL);

	FileDlg.m_ofn.lpstrTitle = "Open Map - File";
	if(FileDlg.DoModal() == IDOK)
	{	
		CMainFrame* pFrame = STATIC_DOWNCAST(CMainFrame, m_pMainWnd);

		// create a new MDI child window
		CMapFrame* pChild = STATIC_DOWNCAST(CMapFrame,
					pFrame->CreateNewChild(RUNTIME_CLASS(CMapFrame),
							IDR_MAPCAP,
							m_hMapMenu,
							m_hMDIAccel) );

		pChild->LoadMap( FileDlg.GetPathName( ));
		pChild->m_Changed=FALSE;
		pChild->GetMapDlg()->ReCalcScreen( );
		pChild->UpdateMenu( );
	}
}


CString GetPath(CString str)
{
	int index = str.ReverseFind( '\\' );
	return str.Left(index + 1);
}


CString GetFile(CString str)
{
	int index = str.ReverseFind( '\\' );
	index = str.GetLength() - index - 1;	// - 1 to get rid of the /
	return str.Right(index);
}
