// NewMap.cpp : implementation file
//

#include "stdafx.h"
#include "NewMap.h"
#include "MapFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CNewMap dialog


CNewMap::CNewMap(CWnd* pParen /*=NULL*/)
	: CDialog(CNewMap::IDD, pParen)
{
	//{{AFX_DATA_INIT(CNewMap)
	m_Height = 32;
	m_Width = 32;
	m_NumLayers = 1;
	m_Fill = 0;
	//}}AFX_DATA_INIT

	active = 0;

}


void CNewMap::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CNewMap)
	DDX_Control(pDX, IDC_TILESET, m_TileSet);
	DDX_Control(pDX, IDC_LAYERSPIN, m_LayerSpin);
	DDX_Control(pDX, IDC_LAYERCOMBO, m_LayerCombo);
	DDX_Text(pDX, IDC_HEIGHT, m_Height);
	DDX_Text(pDX, IDC_WIDTH, m_Width);
	DDX_Text(pDX, IDC_LAYEREDIT, m_NumLayers);
	DDV_MinMaxInt(pDX, m_NumLayers, 1, 10);
	DDX_Text(pDX, IDC_FILL, m_Fill);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CNewMap, CDialog)
	//{{AFX_MSG_MAP(CNewMap)
	ON_EN_CHANGE(IDC_LAYEREDIT, OnChangeNumlayers)
	ON_BN_CLICKED(ID_BROWSE, OnBrowse)
	ON_CBN_SELCHANGE(IDC_LAYERCOMBO, OnSelchangeLayercombo)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CNewMap message handlers

BOOL CNewMap::OnInitDialog() 
{
	CDialog::OnInitDialog();

	CEdit *wnd;
	CSpinButtonCtrl *Spin;
	CComboBox *Combo;

	wnd = (CEdit*)GetDlgItem(IDC_WIDTH);
	wnd->EnableWindow(  );
	wnd = (CEdit*)GetDlgItem(IDC_HEIGHT);
	wnd->EnableWindow(  );
	wnd = (CEdit*)GetDlgItem(IDC_LAYEREDIT);
	wnd->EnableWindow(  );


	Spin = (CSpinButtonCtrl*)GetDlgItem(IDC_LAYERSPIN);
	Spin->EnableWindow( );
	Spin->SetBuddy(wnd);
	Spin->SetRange(1, 10);

	Combo = (CComboBox*)GetDlgItem(IDC_LAYERCOMBO);
	Combo->EnableWindow();
	Combo->SetCurSel(0);



	
	return TRUE;
}

void CNewMap::OnChangeNumlayers() 
{
	CString layer;
	int index = m_LayerCombo.GetCurSel();

	m_NumLayers = m_LayerSpin.GetPos();

	m_LayerCombo.ResetContent();


	for(int i = 0; i < m_NumLayers; i++)
	{
		layer.Format(_T("Layer %d"), i);
		m_LayerCombo.AddString(layer);
	}

	if( index < m_LayerCombo.GetCount() )
		m_LayerCombo.SetCurSel(index);
	else m_LayerCombo.SetCurSel(m_LayerCombo.GetCount() - 1);


}


void CNewMap::OnBrowse() 
{
	CString Filter = "Tile Files (*.bmp)|*.bmp|All Files (*.*)|*.*||";
	CFileDialog FileDlg(TRUE, "*.bmp", NULL, OFN_FILEMUSTEXIST, Filter, NULL);

	FileDlg.m_ofn.lpstrTitle = "Open Map - File";
	if(FileDlg.DoModal())
	{
		m_TileSet.SetWindowText(FileDlg.GetPathName());
	}

}

void CNewMap::OnSelchangeLayercombo() 
{
	CString *str1 = NULL, str2;

	m_TileSet.GetWindowText(str2);

	str1 = new CString(str2);

	m_LayerCombo.SetItemDataPtr(active, str1);

	active = m_LayerCombo.GetCurSel();

	str1 = (CString*) m_LayerCombo.GetItemDataPtr(active);

	if(str1 != NULL)
		m_TileSet.SetWindowText( str1->Left(str1->GetLength()) );
//	else m_TileSet.SetWindowText(NULL);
}


void CNewMap::OnOK() 
{
	CDialog::OnOK();

	CString str1, *str2 = NULL;

	m_TileSet.GetWindowText(str1);

	str2 = new CString(str1);

	m_LayerCombo.SetItemDataPtr(active, &str1);

	m_TileSets.RemoveAll();
	for(int i = 0; i < m_LayerSpin.GetPos(); i++)
	{
		str2 = (CString*) m_LayerCombo.GetItemDataPtr(i);
		m_TileSets.SetAtGrow(i, str2->Left( str2->GetLength() ));
	}
	
}