//-----------------------------------------------------------------------------
// File: proto.cpp
//
// Desc: 
//-----------------------------------------------------------------------------
#define STRICT
#include <basetsd.h>
#include <stdio.h>
#include <math.h>
#include <D3DX8.h>
#include "D3DApp.h"
#include "D3DFile.h"
#include "D3DFont.h"
#include "D3DUtil.h"
#include "DXUtil.h"




//-----------------------------------------------------------------------------
// Defines, constants, and global variables
//-----------------------------------------------------------------------------



//-----------------------------------------------------------------------------
// Name: class CMyD3DApplication
// Desc: Application class. The base class (CD3DApplication) provides the 
//       generic functionality needed in all Direct3D samples. CMyD3DApplication 
//       adds functionality specific to this sample program.
//-----------------------------------------------------------------------------
class CMyD3DApplication : public CD3DApplication
{
	CD3DFont*		m_pFont;              // Font for drawing text

	// ǉ
	LPD3DXFONT		m_lpFont;

	HRESULT ConfirmDevice( D3DCAPS8*, DWORD, D3DFORMAT );
	
protected:
	HRESULT OneTimeSceneInit();
	HRESULT InitDeviceObjects();
	HRESULT RestoreDeviceObjects();
	HRESULT InvalidateDeviceObjects();
	HRESULT DeleteDeviceObjects();
	HRESULT FinalCleanup();
	HRESULT Render();
	HRESULT FrameMove();
	
public:
	CMyD3DApplication();
};


CMyD3DApplication g_d3dApp;

//-----------------------------------------------------------------------------
// Name: WinMain()
// Desc: Entry point to the program. Initializes everything, and goes into a
//       message-processing loop. Idle time is used to render the scene.
//-----------------------------------------------------------------------------
INT WINAPI WinMain( HINSTANCE hInst, HINSTANCE, LPSTR, INT )
{
	
	if( FAILED( g_d3dApp.Create( hInst ) ) )
		return 0;
	
	return g_d3dApp.Run();
}




//-----------------------------------------------------------------------------
// Name: CMyD3DApplication()
// Desc: Application constructor. Sets attributes for the app.
//-----------------------------------------------------------------------------
CMyD3DApplication::CMyD3DApplication()
{
	m_strWindowTitle    = _T("Proto: D3D Example");
	m_bUseDepthBuffer   = TRUE;
	
	m_pFont        = new CD3DFont( _T("Arial"), 12, D3DFONT_BOLD );
}




//-----------------------------------------------------------------------------
// Name: OneTimeSceneInit()
// Desc: Called during initial app startup, this function performs all the
//       permanent initialization.
//-----------------------------------------------------------------------------
HRESULT CMyD3DApplication::OneTimeSceneInit()
{
	
	return S_OK;
}



//-----------------------------------------------------------------------------
// Name: FrameMove()
// Desc: Called once per frame, the call is the entry point for animating
//       the scene.
//-----------------------------------------------------------------------------
HRESULT CMyD3DApplication::FrameMove()
{
	
	return S_OK;
}




//-----------------------------------------------------------------------------
// Name: Render()
// Desc: Called once per frame, the call is the entry point for 3d
//       rendering. This function sets up render states, clears the
//       viewport, and renders the scene.
//-----------------------------------------------------------------------------
HRESULT CMyD3DApplication::Render()
{
	// Clear the viewport
	m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_TARGET | D3DCLEAR_ZBUFFER, D3DCOLOR_XRGB(0,0,255), 1.0f, 0L );
	
	// Begin the scene
	if( SUCCEEDED( m_pd3dDevice->BeginScene() ) )
	{
		
		// Output statistics
		m_pFont->DrawText( 2,  0, D3DCOLOR_ARGB(255,255,255,0), m_strFrameStats );
		m_pFont->DrawText( 2, 20, D3DCOLOR_ARGB(255,255,255,0), m_strDeviceStats );
		m_pFont->DrawText( 2, 40, D3DCOLOR_ARGB(255,255,255,0), "-.-v" );
		
		// ǉ
		LPTSTR lptstrBuf;
		lptstrBuf = new TCHAR[1024];
		//wsprintf(lptstrBuf, "");
		wsprintf(lptstrBuf, "ABCD1234$#");
		RECT drawRect;
		SetRect(&drawRect, 2, 100, 400, 20);
		m_lpFont->DrawText(m_strFrameStats, -1, &drawRect, DT_LEFT | DT_TOP, D3DCOLOR_RGBA(255, 255, 255, 255));
		SetRect(&drawRect, 2, 120, 300, 60);
		m_lpFont->DrawText(lptstrBuf, -1, &drawRect, DT_WORDBREAK | DT_LEFT | DT_TOP, D3DCOLOR_RGBA(255, 255, 255, 255));
		SAFE_DELETE(lptstrBuf);

		// End the scene.
		m_pd3dDevice->EndScene();
	}
	
	return S_OK;
}




//-----------------------------------------------------------------------------
// Name: InitDeviceObjects()
// Desc: This creates all device-dependent managed objects, such as managed
//       textures and managed vertex buffers.
//-----------------------------------------------------------------------------
HRESULT CMyD3DApplication::InitDeviceObjects()
{
	// Initialize the font's internal textures
	m_pFont->InitDeviceObjects( m_pd3dDevice );
	
	
	return S_OK;
}




//-----------------------------------------------------------------------------
// Name: RestoreDeviceObjects()
// Desc: Restore device-memory objects and state after a device is created or
//       resized.
//-----------------------------------------------------------------------------
HRESULT CMyD3DApplication::RestoreDeviceObjects()
{
	// Restore the device objects for the meshes and fonts
	m_pFont->RestoreDeviceObjects();
	

	// ǉ
	LOGFONT lFont;
	
	ZeroMemory(&lFont, sizeof(LOGFONT));
	lFont.lfHeight = 12;
	lFont.lfWidth = 0;
	lFont.lfWeight = FW_BOLD; 
	lFont.lfCharSet = SHIFTJIS_CHARSET;
	lFont.lfOutPrecision = OUT_DEFAULT_PRECIS;
	lFont.lfClipPrecision = CLIP_DEFAULT_PRECIS;
	lFont.lfQuality = PROOF_QUALITY;
	lFont.lfPitchAndFamily = FIXED_PITCH | FF_MODERN;
	strcpy(lFont.lfFaceName, "ü");
	
	D3DXCreateFontIndirect(m_pd3dDevice, &lFont, &m_lpFont);


	// Set the transform matrices (view and world are updated per frame)
	D3DXMATRIX matProj;
	FLOAT fAspect = m_d3dsdBackBuffer.Width / (FLOAT)m_d3dsdBackBuffer.Height;
	D3DXMatrixPerspectiveFovLH( &matProj, D3DX_PI/4, fAspect, 1.0f, 100.0f );
	m_pd3dDevice->SetTransform( D3DTS_PROJECTION, &matProj );
	
	// Set up the default texture states
	m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLOROP,   D3DTOP_SELECTARG1 );
	m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
	m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP,   D3DTOP_SELECTARG1 );
	m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE );
	m_pd3dDevice->SetTextureStageState( 0, D3DTSS_MINFILTER, D3DTEXF_LINEAR );
	m_pd3dDevice->SetTextureStageState( 0, D3DTSS_MAGFILTER, D3DTEXF_LINEAR );
	m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ADDRESSU,  D3DTADDRESS_CLAMP );
	m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ADDRESSV,  D3DTADDRESS_CLAMP );
	
	m_pd3dDevice->SetRenderState( D3DRS_DITHERENABLE, TRUE );
	m_pd3dDevice->SetRenderState( D3DRS_ZENABLE,      TRUE );
	m_pd3dDevice->SetRenderState( D3DRS_LIGHTING,     FALSE );
	
	return S_OK;
}




//-----------------------------------------------------------------------------
// Name: InvalidateDeviceObjects()
// Desc: Called when the device-dependent objects are about to be lost.
//-----------------------------------------------------------------------------
HRESULT CMyD3DApplication::InvalidateDeviceObjects()
{
	m_pFont->InvalidateDeviceObjects();

	// ǉ
	SAFE_RELEASE( m_lpFont );
	
	return S_OK;
}




//-----------------------------------------------------------------------------
// Name: DeleteDeviceObjects()
// Desc: Called when the app is exiting, or the device is being changed,
//       this function deletes any device dependent objects.
//-----------------------------------------------------------------------------
HRESULT CMyD3DApplication::DeleteDeviceObjects()
{
	m_pFont->DeleteDeviceObjects();
	
	return S_OK;
}




//-----------------------------------------------------------------------------
// Name: FinalCleanup()
// Desc: Called before the app exits, this function gives the app the chance
//       to cleanup after itself.
//-----------------------------------------------------------------------------
HRESULT CMyD3DApplication::FinalCleanup()
{
	SAFE_DELETE( m_pFont );
	
	return S_OK;
}




//-----------------------------------------------------------------------------
// Name: ConfirmDevice()
// Desc: Called during device intialization, this code checks the device
//       for some minimum set of capabilities
//-----------------------------------------------------------------------------
HRESULT CMyD3DApplication::ConfirmDevice( D3DCAPS8* pCaps, DWORD dwBehavior,
													  D3DFORMAT Format )
{
	if( dwBehavior & D3DCREATE_PUREDEVICE )
		return E_FAIL; // GetTransform doesn't work on PUREDEVICE
	
	// This sample uses alpha textures and/or straight alpha. Make sure the
	// device supports them
	if( pCaps->TextureCaps & D3DPTEXTURECAPS_ALPHAPALETTE )
		return S_OK;
	if( pCaps->TextureCaps & D3DPTEXTURECAPS_ALPHA )
		return S_OK;
	
	return E_FAIL;
}




